/*
 * chump_player.h
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#ifndef _CHUMP_PLAYER_H_
#define _CHUMP_PLAYER_H_

#include "sequence_form.h"

typedef struct {
  sequence_form_t * sequence_form;
  double * sigma;
} chump_t;

void * create_chump(sequence_form_t * restrict sequence_form, int who, int T, 
		    const char * restrict params);
void free_chump(chump_t * restrict player);
const double * get_strategy_chump(chump_t * restrict player);
void update_strategy_chump(chump_t * restrict player, double * restrict payoffs);

#endif /* _CHUMP_PLAYER_H_ */
