/*
 * chump_player.c
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#include "args.h"
#include "game.h"
#include "rng.h"
#include "sequence_form.h"
#include "strategy.h"
#include "util.h"
#include "verify.h"

#include "chump_player.h"

void * create_chump(sequence_form_t * restrict sequence_form, int who, int T, 
		    const char * restrict params) {
  chump_t * player;
  rng_t * rng;
  int i, seed;
  arg_t args[] = {
    {"seed", "d", &seed},
    {NULL},
  };

  assert(sequence_form);
  assert(valid_player(who));
  assert(T >= 0);

  seed = rng_seed_time();
  parse_args(args, params);
  
  player = xmalloc(sizeof(chump_t));
  player->sequence_form = sequence_form;
  player->sigma         = new_strategy(sequence_form_sequences(sequence_form, who));
  
  rng = xmalloc(sizeof(rng_t));
  rng_init_gen_rand(rng, seed);
  for(i=1; i<sequences_n(sequence_form_sequences(sequence_form, who)); ++i) {
    player->sigma[i] = rng_genrand_open_open(rng);
  }
  xfree(rng);

  normalize_strategy(sequence_form_sequences(sequence_form, who), player->sigma, 1.);
  
  return player;
}

void free_chump(chump_t * restrict player) {
  assert(player);
  xfree(player->sigma);
  xfree(player);
}

const double * get_strategy_chump(chump_t * restrict player) {
  assert(player);
  return player->sigma;
}

void update_strategy_chump(chump_t * restrict player, double * restrict payoffs) {
  assert(player);
  assert(payoffs);
}
