/*
 * cfr_player.h
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#ifndef _CFR_PLAYER_H_
#define _CFR_PLAYER_H_

#include "sequence_form.h"

typedef struct {
  sequence_form_t * sequence_form;
  int who;
  double * sigma, * regret;
} cfr_player_t;

void * create_cfr(sequence_form_t * restrict sequence_form, int who, int T, 
		  const char * restrict params);
void free_cfr(cfr_player_t * restrict player);
const double * get_strategy_cfr(cfr_player_t * restrict player);
void update_strategy_full_cfr(cfr_player_t * restrict player, double * restrict payoffs);

#endif /* _CFR_PLAYER_H_ */
