/*
 * best_response.c
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#include "abstraction.h"
#include "sequence_form.h"
#include "strategy.h"
#include "verify.h"

#include "best_response.h"

double best_response(sequences_t * restrict sequences, double * restrict payoffs) {
  int i, info_set, j, best_j;
  double v;

  for(i=abstract_info_sets(sequences_abstraction(sequences))-1; i>=0; --i) {
    info_set = info_set_order(sequences, i);
    best_j = j = first_sequence(sequences, info_set);
    v = payoffs[best_j];
    for(++j; j<=last_sequence(sequences, info_set); ++j) {
      if (payoffs[j] > v) {
	v = payoffs[j];
	best_j = j;
      }
    }
    payoffs[parent_sequence(sequences, info_set)] += v;
    for(j=first_sequence(sequences, info_set);
	j<=last_sequence(sequences, info_set); ++j) {
      payoffs[j] = 0;
    }
    payoffs[best_j] = 1;
  }

  v = payoffs[EMPTY_SEQUENCE];
  normalize_strategy(sequences, payoffs, 1.);

  return v;
}
