/*
 * args.c
 * author: Kevin Waugh (waugh@cs.cmu.edu)
 */

#include <stdio.h>
#include <string.h>

#include "verify.h"

#include "args.h"

void parse_args(const arg_t * args, const char * string) {
  const arg_t * entry;
  char type[64];
  int n;

  while(string && *string) {
    for(entry=args; entry->name; ++entry) {
      if (!strncmp(entry->name, string, strlen(entry->name))) {
	break;
      }
    }
    verify(entry->name);
    string += strlen(entry->name);
    verify(*string == '=');
    ++string;
    sprintf(type, "%%%s%%n", entry->type);
    verify(sscanf(string, type, entry->where, &n) == 1);
    string += n;
    if (*string == ',') {
      ++string;
    } else {
      verify(!*string);
    }
  }
}
