#!/usr/bin/env python
# leduc.py

from datetime import datetime
from getopt import getopt
from leduc import leduc_state, walk_game
import sys

def null_chance(state, actions, data):
    pass

def null_terminal(state, data):
    pass

def count_player(state, actions, data):
    if state.who == data.who:
        info_set = '/%s%s' % (state.cards[state.who], ''.join(state.public))
        if info_set not in data.info_sets:
            if state.round == 0:
                cards = state.cards[data.who]
            else:
                cards = '%s%s' % (state.cards[data.who], state.board)
            abstract_info_set = '/%d%s' % (data.abstraction[cards], ''.join(state.betting))
            if abstract_info_set in data.abstract_info_sets:
                m = data.abstract_info_sets[abstract_info_set]
            else:
                m = len(data.abstract_info_sets)
                data.abstract_info_sets[abstract_info_set] = m
            n = len(data.info_sets)
            data.info_sets[info_set] = (n, m)

if __name__ == "__main__":
    if len(sys.argv) == 1:
        print sys.argv[0], '-p player', '-a abstraction', '-n name'
    else:
        opts, args = getopt(sys.argv[1:], 'p:a:n:')
        data = leduc_state()
        data.who         = -1
        abstraction      = None
        abstraction_name = None
        for o, a in opts:
            if o == '-p':
                data.who = int(a)
            elif o == '-a':
                data.abstraction = {}
                abstraction_rough_name = a
                for i, s in enumerate(a.split(':')):
                    for t in s.split(','):
                        data.abstraction[t] = i
            elif o == '-n':
                abstraction_name = a

        data.info_sets = {}
        data.abstract_info_sets = {}
        walk_game(null_chance, count_player, null_terminal, data)

        if abstraction_name == None:
            abstraction_name = '%s-p%d' % (abstraction_rough_name, data.who)

        print '# automatically generated on', datetime.now()
        print '#', abstraction_name, abstraction_rough_name, 'player:', data.who
        print "'%s' 'Leduc poker' %d %d" % (abstraction_name, data.who, len(data.abstract_info_sets))
        for (n, m) in data.info_sets.itervalues():
            print n, m
