#!/usr/bin/env python
# leduc.py

from datetime import datetime

class leduc_state(object):
    pass

def walk_fold(state, chance_func, player_func, terminal_func, data):
    return terminal_func(state, data)

def walk_showdown(state, chance_func, player_func, terminal_func, data):
    return terminal_func(state, data)

def walk_chance(state, chance_func, player_func, terminal_func, data):
    old_who    = state.who
    old_raises = state.raises
    state.who   = 0
    state.round = 1
    state.raises = 0
    actions = []
    for board in ['J', 'Q', 'K']:
        if not (state.cards[0] == state.cards[1] and state.cards[0] == board):
            state.name.append('/%s/' % (board))
            state.public.append('/%s/' % (board))
            state.board = board
            u = walk_betting(state, chance_func, player_func, terminal_func, data)
            state.public.pop()
            state.name.pop()
            actions.append((board, u))
    state.round = 0
    state.raises = old_raises
    state.who = old_who

    u = chance_func(state, actions, data)
    return u

def walk_betting(state, chance_func, player_func, terminal_func, data):
    actions = []

    to_call = state.pot[1-state.who]-state.pot[state.who]

    bet_size = 2
    if state.round:
        bet_size = 4

    if state.raises < 2:
        state.raises += 1
        state.pot[state.who] += to_call + bet_size
        state.who = 1 - state.who
        state.name.append('r')
        state.public.append('r')
        state.betting.append('r')
        u = walk_betting(state, chance_func, player_func, terminal_func, data)
        state.betting.pop()
        state.public.pop()
        state.name.pop()
        state.who = 1 - state.who
        state.pot[state.who] -= to_call + bet_size
        state.raises -= 1
        actions.append(('r', u))

    state.name.append('c')
    state.public.append('c')
    state.betting.append('c')
    if to_call or state.who == 1:
        if state.round == 1:
            state.pot[state.who] += to_call
            u = walk_showdown(state, chance_func, player_func, terminal_func, data)
            state.pot[state.who] -= to_call
            actions.append(('c', u))
        else:
            state.pot[state.who] += to_call
            u = walk_chance(state, chance_func, player_func, terminal_func, data)
            state.pot[state.who] -= to_call
            actions.append(('c', u))
    else:
        state.pot[state.who] += to_call
        state.who = 1-state.who
        u = walk_betting(state, chance_func, player_func, terminal_func, data)
        state.who = 1-state.who
        state.pot[state.who] -= to_call
        actions.append(('c', u))
    state.betting.pop()
    state.public.pop()
    state.name.pop()

    if to_call:
        state.name.append('f')
        state.public.append('f')
        state.betting.append('f')
        state.who_folded = state.who
        u = walk_fold(state, chance_func, player_func, terminal_func, data)
        state.who_folded = -1
        state.betting.pop()
        state.public.pop()
        state.name.pop()
        actions.append(('f', u))

    u = player_func(state, actions, data)
    return u

def walk_game(chance_func, player_func, terminal_func, data):
    state = leduc_state()
    state.raises     = 0
    state.round      = 0
    state.who        = 0
    state.pot        = [1,1]
    state.who_folded = -1
    state.name       = ['/']
    state.public     = ['/']
    state.betting    = ['/']

    actions = []
    for c1 in ['J', 'Q', 'K']:
        for c2 in ['J', 'Q', 'K']:
            state.cards = [c1, c2];
            state.name.append('%s%s/'%(c1, c2))
            u = walk_betting(state, chance_func, player_func, terminal_func, data)
            state.name.pop()
            actions.append(('%s%s'%(c1,c2), u))
    state.round = -1
    chance_func(state, actions, data)

def count_chance(state, actions, data):
    data.chance_histories += 1
    data.chance_actions   += len(actions)

def count_player(state, actions, data):
    data.player_histories[state.who] += 1
    data.player_actions[state.who]   += len(actions)
    info_set = '/%s%s' % (state.cards[state.who], ''.join(state.public))
    if info_set not in data.info_sets[state.who]:
        n = len(data.info_sets[state.who])
        data.info_sets[state.who][info_set] = n

def count_terminal(state, data):
    data.terminal_histories += 1

def print_chance(state, actions, data):
    u = data.chance
    data.chance += 1

    print "%d '%s' %d" % (u, ''.join(state.name), len(actions)),
    for (name, v) in actions:
        if state.round == -1:
            if name[0] == name[1]:
                rem = 2
            else:
                rem = 4
        else:
            rem = 2
            if state.cards[1] == name:
                rem -= 1
            if state.cards[0] == name:
                rem -= 1
        print "'%s' %d %d" % (name, v, rem),
    print

    return u

def print_player(state, actions, data):
    u = data.player
    data.player += 1

    info_set_name = '/%s%s' % (state.cards[state.who], ''.join(state.public))
    info_set = data.info_sets[state.who][info_set_name]
    print "%d '%s' %d %d %d" % (u, ''.join(state.name), state.who, info_set, len(actions)),
    for (name, v) in actions:
        print "'%s' %d" % (name, v),
    print

    return u

def print_terminal(state, data):
    u = data.terminal
    data.terminal += 1

    if state.who_folded == -1:
        value = state.pot[0]
        if state.cards[0] == state.cards[1]:
            value = 0
        elif state.cards[1] == state.board:
            value = -value
        elif state.cards[0] == state.board:
            pass
        elif state.cards[1] == 'K' or (state.cards[1] == 'Q' and state.cards[0] == 'J'):
            value = -value
    else:
        value = state.pot[state.who_folded]
        if state.who_folded == 0:
            value = -value
    
    print "%d '%s' %d" % (u, ''.join(state.name), value)
    return u

if __name__ == "__main__":
    data = leduc_state()
    data.info_sets           = [{}, {}]
    data.chance_histories    = 0
    data.chance_actions      = 0
    data.player_histories    = [0,0]
    data.player_actions      = [0,0]
    data.terminal_histories  = 0
    walk_game(count_chance, count_player, count_terminal, data)

    print '# automatically generated on', datetime.now()

    print "'Leduc poker'", data.chance_histories, data.player_histories[0]+data.player_histories[1],
    print data.terminal_histories, data.chance_histories-1, data.chance_actions+data.player_actions[0]+data.player_actions[1],
    print data.chance_actions, len(data.info_sets[0]), len(data.info_sets[1])

    data2 = leduc_state()
    data2.chance    = 0
    data2.player    = data.chance_histories
    data2.terminal  = data.chance_histories+data.player_histories[0]+data.player_histories[1]
    data2.info_sets = data.info_sets
    walk_game(print_chance, print_player, print_terminal, data2)
   

