#!/usr/bin/env python
# kuhn.py
#

from datetime import datetime

print '# automatically generated on', datetime.now()

# /    0 p
# /c   1 p
# /cc  2 z
# /cr  3 p
# /crc 4 z
# /crf 5 z
# /r   7 p
# /rf  8 z
# /rc  9 z
# chance actions: JQ, JK, QJ, QK, KJ, KQ

# /
def p1_1_history(chance):
    return 4*chance+1

# /c
def p2_1_history(chance):
    return 4*chance+2

# /cr
def p1_2_history(chance):
    return 4*chance+3

# /r
def p2_2_history(chance):
    return 4*chance+4

# /
def p1_1_info_set(chance):
    return chance/2

# /c
def p2_1_info_set(chance):
    if chance == 2 or chance == 4:
        return 0
    elif chance == 0 or chance == 5:
        return 1
    else:
        return 2

# /cr
def p1_2_info_set(chance):
    return 3+chance/2

# /r
def p2_2_info_set(chance):
    return 3+p2_1_info_set(chance)

def cc_history(chance):
    return 25+5*chance

def crc_history(chance):
    return 25+5*chance+1

def crf_history(chance):
    return 25+5*chance+2

def rc_history(chance):
    return 25+5*chance+3

def rf_history(chance):
    return 25+5*chance+4

CHANCE = ['JQ', 'JK', 'QJ', 'QK', 'KJ', 'KQ']
SHOWDOWN = [-1, -1, 1, -1, 1, 1]

# /
def p1_1(chance):
    global CHANCE
    print p1_1_history(chance), "'/%s/'" % (CHANCE[chance]), 0, p1_1_info_set(chance), 2,
    print "'c'", p2_1_history(chance), "'r'", p2_2_history(chance)

# /c
def p2_1(chance):
    global CHANCE
    print p2_1_history(chance), "'/%s/c'" % (CHANCE[chance]), 1, p2_1_info_set(chance), 2,
    print "'c'", cc_history(chance), "'r'", p1_2_history(chance)

# /cr
def p1_2(chance):
    global CHANCE
    print p1_2_history(chance), "'/%s/cr'" % (CHANCE[chance]), 0, p1_2_info_set(chance), 2,
    print "'c'", crc_history(chance), "'f'", crf_history(chance)

# /r
def p2_2(chance):
    global CHANCE
    print p2_2_history(chance), "'/%s/r'" % (CHANCE[chance]), 1, p2_2_info_set(chance), 2,
    print "'c'", rc_history(chance), "'f'", rf_history(chance)

def cc(chance):
    global CHANCE
    global SHOWDOWN
    print cc_history(chance), "'/%s/cc'" % (CHANCE[chance]), SHOWDOWN[chance]

def crc(chance):
    global CHANCE
    global SHOWDOWN
    print crc_history(chance), "'/%s/crc'" % (CHANCE[chance]), 2*SHOWDOWN[chance]

def crf(chance):
    global CHANCE
    print crf_history(chance), "'/%s/crf'" % (CHANCE[chance]), -1

def rc(chance):
    global CHANCE
    global SHOWDOWN
    print rc_history(chance), "'/%s/rc'" % (CHANCE[chance]), 2*SHOWDOWN[chance]

def rf(chance):
    global CHANCE
    print rf_history(chance), "'/%s/rf'" % (CHANCE[chance]), 1

print "'Kuhn poker'", 1, 4*6, 5*6, 0, 6+6*4*2, 6, 6, 6

print 0, "'/'", 6,
for chance in range(6):
    print "'%s'" % (CHANCE[chance]), p1_1_history(chance), 1,
print

for chance in range(6):
    p1_1(chance)
    p1_2(chance)
    p2_1(chance)
    p2_2(chance)
    cc(chance)
    crc(chance)
    crf(chance)
    rc(chance)
    rf(chance)
