/*
 * =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
 
Copyright (c) 2009-2011, Kornel Laskowski
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of
      conditions and the following disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of KTH Speech Music and Hearing nor the names of its contributors may be
      used to endorse or promote products derived from this software without specific prior written
      permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 ===+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

#include <stdlib.h>
#include <assert.h>
#include <sys/time.h>
#include "stopwatch.h"

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

StopWatch *  stopwatchSTART()
{
	StopWatch *  swPtr;
	struct timeval  tv;

	swPtr = (StopWatch *) malloc( sizeof( StopWatch ) );
	assert( swPtr != (StopWatch *) NULL );

	gettimeofday( &tv, (struct timezone *) NULL );

	swPtr->start_sec = (int) (tv.tv_sec);
	swPtr->start_usec = (int) (tv.tv_usec);
	swPtr->state = StopWatchState_RUNNING;

	return swPtr;
}

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

double stopwatchSTOP
	(
		StopWatch *  swPtr
	)
{
	struct timeval  tv;
	int             stop_sec;
	int             stop_usec;
	double          duration_sec;

	assert( swPtr->state == StopWatchState_RUNNING );

	gettimeofday( &tv, (struct timezone *) NULL );

	stop_sec = (int) (tv.tv_sec);
	stop_usec = (int) (tv.tv_usec);
	duration_sec = (double) (stop_sec - swPtr->start_sec)
		+ ((double) (stop_usec - swPtr->start_usec)) / 1000000.0;

	free( (void *) swPtr );

	return duration_sec;
}

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

