/*
 * =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
 
Copyright (c) 2009-2011, Kornel Laskowski
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of
      conditions and the following disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of KTH Speech Music and Hearing nor the names of its contributors may be
      used to endorse or promote products derived from this software without specific prior written
      permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 ===+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

#ifndef __MSF_H__
#define __MSF_H__

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

#include "windowpair.h"
#include "mel.h"

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

static const double    default_tint      =      0.011;
static const double    default_text      =      0.009;
static const double    default_tsep      =      0.014;
static const double    default_tfra      =      0.008;
static const double    default_fs        =  16000.0;
static const WinShape  default_winShape  =  WinShape_HANN_HANN;

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

typedef struct
{
	double           tint;
	double           text;
	double           tsep;
	double           fs;
	WinShape         winShape;
	int              Tint;
	int              Text;
	int              Tsep;
	double *         hL;
	double *         hR;
	int              Nh;
	int              NhPow2;
	double *         fftL;
	double *         fftR;
	int              Nfft;
	double *         magL;
	double *         magR;
	int              Nmag;
	MelFilterBank *  melPtr;
	double *         melL;
	double *         melR;
	int              Nmel;
}
MsfComputer;

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

void msfCREATE
	(
		const double    tint,
		const double    text,
		const double    tsep,
		const double    fs,
		const WinShape  winShape,
		int *           TsizePow2Ptr,
		MsfComputer **  msfComputerPtrPtr
	);

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

void msfDESTROY
	(
		MsfComputer **  msfComputerPtrPtr
	);

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

void msfCOMPUTE
	(
		MsfComputer *   msfComputerPtr,
		const double *  audio,
		const int       begIdx,
		const int       nAudio,
		double *        x
	);

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

void msfPRINT
	(
		const MsfComputer *  msfComputerPtr
	);

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

void msfPRINTTAB
	(
		MsfComputer **  msfComputerPtrTab,
		const int       n
	);

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

#endif /* __MSF_H__ */

