/*
 * =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
 
Copyright (c) 2009-2011, Kornel Laskowski
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of
      conditions and the following disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of KTH Speech Music and Hearing nor the names of its contributors may be
      used to endorse or promote products derived from this software without specific prior written
      permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 ===+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include "filename.h"

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

void filenameCREATE
	(
		char **       fileNamePtr,
		const char *  dirName,
		const char *  mId,
		const char *  chanId,
		const char *  extension
	)
{
	int  fileNameLen;

	fileNameLen = strlen( dirName ) + 1
		+ strlen( mId ) + 1
		+ strlen( chanId ) + 1
		+ strlen( extension ) + 1;

	*fileNamePtr = (char *) malloc( fileNameLen * sizeof( char ) );
	assert( *fileNamePtr != (char *) NULL );
	sprintf( *fileNamePtr, "%s/%s_%s.%s", dirName, mId, chanId, extension );

	return;
}

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

void filenameDESTROY
	(
		char **  fileNamePtr
	)
{
	free( (void *) (*fileNamePtr) );
	*fileNamePtr = (char *) NULL;

	return;
}

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

void filenameGETLIST
	(
		const char *  locationPathName,
		const char *  extensionStr,
		char ***      fileNameTabPtr,
		char ***      pathNameTabPtr,
		int *         nFilesPtr
	)
{
	int          extensionStrLen;
	int          locationPathNameLen;
	struct stat  statBuf;
	char **      fileNameTab;
	char **      pathNameTab;
	int          nFiles;

	extensionStrLen = 0;
	if ( extensionStr != (char *) NULL )
	{
		extensionStrLen = strlen( extensionStr );
	}
	locationPathNameLen = strlen( locationPathName );

	if ( stat( locationPathName, &statBuf ) != 0 )
	{
		nFiles = 0;
		fileNameTab = (char **) NULL;
		pathNameTab = (char **) NULL;
	}
	else if ( S_ISREG( statBuf.st_mode ) )
	{
		/* one file */

		int  validFileFlag;

		validFileFlag = 0;

		if ( extensionStr != (char *) NULL )
		{
			if
				(
					strncmp
						(
							locationPathName + locationPathNameLen
								- extensionStrLen,
							extensionStr,
							extensionStrLen
						)
					== 0
				)
			{
				validFileFlag = 1;
			}
		}
		else
		{
			validFileFlag = 1;
		}

		if ( validFileFlag )
		{
			nFiles = 1;

			if ( fileNameTabPtr != (char ***) NULL )
			{
				fileNameTab = (char **) malloc( nFiles * sizeof( char * ) );
				assert( fileNameTab != (char **) NULL );

				fileNameTab[ 0 ] = (char *)
					malloc( (locationPathNameLen + 1) * sizeof( char ) );
				assert( fileNameTab[ 0 ] != (char *) NULL );
				strcpy( fileNameTab[ 0 ], locationPathName );
			}

			if ( pathNameTabPtr != (char ***) NULL )
			{
				pathNameTab = (char **) malloc( nFiles * sizeof( char * ) );
				assert( pathNameTab != (char **) NULL );

				pathNameTab[ 0 ] = (char *)
					malloc( (locationPathNameLen + 1) * sizeof( char ) );
				assert( pathNameTab[ 0 ] != (char *) NULL );
				strcpy( pathNameTab[ 0 ], locationPathName );
			}
		}
		else
		{
			nFiles = 0;
			fileNameTab = (char **) NULL;
			pathNameTab = (char **) NULL;
		}
	}
	else if ( S_ISDIR( statBuf.st_mode ) )
	{
		/* a directory */

		DIR *            dirPtr;
		struct dirent *  direntPtr;

		nFiles = 0;

		dirPtr = opendir( locationPathName );
		assert( dirPtr != (DIR *) NULL );

		while ( ( direntPtr = readdir( dirPtr ) ) != (struct dirent *) NULL )
		{
			char *  fileName;
			int     fileNameLen;
			int     validFileFlag;

			fileName = direntPtr->d_name;
			fileNameLen = strlen( fileName );

			validFileFlag = 0;

			if ( extensionStr != (char *) NULL )
			{
				if
					(
						strncmp
							(
								fileName + fileNameLen
									- extensionStrLen,
								extensionStr,
								extensionStrLen
							)
						== 0
					)
				{
					validFileFlag = 1;
				}
			}
			else if
				(
					( strcmp( fileName, "." ) != 0 )
				&&
					( strcmp( fileName, ".." ) != 0 )
				)
			{
				validFileFlag = 1;
			}

			if ( validFileFlag )	
			{
				nFiles ++;
			}
		}

		closedir( dirPtr );

		if ( nFiles > 0 )
		{
			int  fileIdx;

			if ( fileNameTabPtr != (char ***) NULL )
			{
				fileNameTab = (char **) malloc( nFiles * sizeof( char * ) );
				assert( fileNameTab != (char **) NULL );
			}

			if ( pathNameTabPtr != (char ***) NULL )
			{
				pathNameTab = (char **) malloc( nFiles * sizeof( char * ) );
				assert( pathNameTab != (char **) NULL );
			}
 
			fileIdx = 0;

			dirPtr = opendir( locationPathName );
			assert( dirPtr != (DIR *) NULL );

			while ( ( direntPtr = readdir( dirPtr ) ) != (struct dirent *) NULL )
			{
				char *  fileName;
				int     fileNameLen;
				int     validFileFlag;

				fileName = direntPtr->d_name;
				fileNameLen = strlen( fileName );

				validFileFlag = 0;

				if ( extensionStr != (char *) NULL )
				{
					if 
						( 
							strncmp
								(
									fileName + fileNameLen
										- extensionStrLen,
									extensionStr,
									extensionStrLen
								)
							== 0
						)
					{
						validFileFlag = 1;
					}
				}
				else if
					(
						( strcmp( fileName, "." ) != 0 )
					&&
						( strcmp( fileName, ".." ) != 0 )
					)
				{
					validFileFlag = 1;
				}

				if ( validFileFlag )
				{
					assert( fileIdx < nFiles );

					if ( fileNameTabPtr != (char ***) NULL )
					{
						fileNameTab[ fileIdx ] = (char *)
							malloc( (fileNameLen + 1) * sizeof( char ) );
						assert( fileNameTab[ fileIdx ] != (char *) NULL );
						sprintf( fileNameTab[ fileIdx ], "%s", fileName );
					}

					if ( pathNameTabPtr != (char ***) NULL )
					{
						int  pathNameLen;

						pathNameLen = locationPathNameLen + 1 + fileNameLen;
						pathNameTab[ fileIdx ] = (char *)
							malloc( (pathNameLen + 1) * sizeof( char ) );
						assert( pathNameTab[ fileIdx ] != (char *) NULL );
						sprintf
							(
								pathNameTab[ fileIdx ],
								"%s/%s",
								locationPathName,
								fileName
							);
					}

					fileIdx ++;
				}
			}

			closedir( dirPtr );
		}
		else
		{
			nFiles = 0;
			fileNameTab = (char **) NULL;
			pathNameTab = (char **) NULL;
		}
	}
	else
	{
		nFiles = 0;
		fileNameTab = (char **) NULL;
		pathNameTab = (char **) NULL;
	}

	*nFilesPtr = nFiles;
	if ( fileNameTabPtr != (char ***) NULL )
	{
		*fileNameTabPtr = fileNameTab;
	}
	if ( pathNameTabPtr != (char ***) NULL )
	{
		*pathNameTabPtr = pathNameTab;
	}

	return;
}

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

void filenameFREELIST
	(
		char **    fileNameTab,
		char **    pathNameTab,
		const int  nFiles
	)
{
	int  fileIdx;

	for ( fileIdx = 0; fileIdx < nFiles; fileIdx ++ )
	{
		if ( fileNameTab != (char **) NULL )
		{
			free( (void *) (fileNameTab[ fileIdx ]) );
		}

		if ( pathNameTab != (char **) NULL )
		{
			free( (void *) (pathNameTab[ fileIdx ]) );
		}
	}

	if ( fileNameTab != (char **) NULL )
	{
		free( (void *) fileNameTab );
	}

	if ( pathNameTab != (char **) NULL )
	{
		free( (void *) pathNameTab );
	}

	return;
}

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

