/*
 * ran1.c -- generation of uniform deviates
 *
 *  (c) 2003 kornel laskowski
 *
 * This code originates from Numerical Recipes in C, chapter 7.1, p 280;
 * the return value has been promoted to double.
 */

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7-- */

long   idumValue;
long * idum = &idumValue;

#define IA 16807
#define IM 2147483647
#define AM (1.0/IM)
#define IQ 127773
#define IR 2836
#define NTAB 32
#define NDIV (1+(IM-1)/NTAB)
#include <float.h>
#define RNMX (1.0-DBL_EPSILON) 

double
	ran1(long *idum)
	/*
	 * Minimal random number generator of Park and Miller with
	 * Bays-Durham shuffle and added safeguards. Returns a uniform
	 * random deviate between 0.0 and 1.0 (exclusive of the endpoint
	 * values). Call with idum a negative integer to initialize;
	 * thereafter, do not * alter idum between successive deviates in
	 * a sequence. RNMX should approximate the largest floating value
	 * that is less than 1.
	 */
{
	int j;
	long k;
	static long iy=0;
	static long iv[NTAB];
	double temp;

	if (*idum <= 0 || !iy) {           /* Initialize. */
		if (-(*idum) < 1) *idum=1; /* Be sure to prevent idum=0. */
		else *idum = -(*idum);
		for (j=NTAB+7;j>=0;j--) {  /* Load the suffle table */
			k=(*idum)/IQ;      /*  (after 8 warm-ups). */
			*idum=IA*(*idum-k*IQ)-IR*k;
			if (*idum < 0) *idum += IM;
			if (j < NTAB) iv[j] = *idum;
		}
		iy=iv[0];
	}
	k=(*idum)/IQ;               /* Start here when not initializing. */
	*idum=IA*(*idum-k*IQ)-IR*k; /* Compute idum=(IA*idum)%IM without */
	if (*idum < 0) *idum += IM; /*  overflows by Schrage's method. */
	j=iy/NDIV;                  /* Will be in the range 0..NTAB-1. */
	iy=iv[j];                   /* Output previously stored value */
	iv[j] = *idum;              /*  and refill the shuffle table. */
	if ((temp=AM*iy) > RNMX) return RNMX; /* Because users don't */ 
	else return temp;           /*  expect endpoint values. */ 
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7-- */

