/*
 * =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
 
Copyright (c) 2011, Kornel Laskowski
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of
      conditions and the following disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of Sigtactica Research or of the Royal Institute of Technology (KTH) or of
      Carnegie Mellon University nor the names of their contributors may be used to endorse or
      promote products derived from this software without specific prior written permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 ===+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

#include <stdlib.h>
#include <assert.h>
#include "DblMatrix.h"
#include "bit.h"
#include "q.h"

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

void QReadAndEncode
	(
		const char *  inPathName,
		int **        qPtr,
		int *         TPtr,
		int *         KPtr
	)
{
	double **  Q;
	int        T;
	int        K;
	int *      q;

	DblMatrixREAD( inPathName, &Q, &T, &K );

	q = (int *) malloc( T * sizeof( int ) );
	assert( q != (int *) NULL );

	{
		int  t;

		for ( t = 0; t < T; t ++ )
		{
			int  q_t;
			int  k;

			q_t = 0;
			for ( k = 0; k < K; k ++ )
			{
				q_t += ( ((int)(Q[ t ][ k ] > 0.5)) << k );
			}
			q[ t ] = q_t;
		}
	}

	DblMatrixFREE( &Q, T, K );

	*qPtr = q;
	*TPtr = T;
	*KPtr = K;

	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

int QCompare
	(
		const int  q1,
		const int  q2,
		const int  K
	)
{
	int  Ksame;
	int  k;

	Ksame = 0;
	for ( k = 0; k < K; k ++ )
	{
		if ( GETBIT( q1, k ) == GETBIT( q2, k ) )
		{
			Ksame ++;
		} 
	}

	return Ksame;
}

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

