/*
 * =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
 
Copyright (c) 2010, Kornel Laskowski
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of
      conditions and the following disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of Sigtactica Research or of the Royal Institute of Technology (KTH) or of
      Carnegie Mellon University nor the names of their contributors may be used to endorse or
      promote products derived from this software without specific prior written permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 ===+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

#include <stdlib.h>
#include <assert.h>
#include <math.h>
#include "tmcount.h"

/*==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+===*/

void tmcountALLOC
	(
		TMCount *  tmCountPtr,
		const int  M,
		const int  K,
		const int  Kmax
	)
{
	int     N;
	int **  c;

	assert( M > 1 );
	assert( K > 0 );

	N = (int) pow( (double) M, (double) K );

	c = (int **) malloc( N * sizeof( int * ) );
	assert( c != (int **) NULL );

	{
		int  i;

		for ( i = 0; i < N; i ++ )
		{
			int *  c_i_;

			c_i_ = (int *) malloc( N * sizeof( int ) );
			assert( c_i_ != (int *) NULL );

			c[ i ] = c_i_;
		}
	}

	tmCountPtr->M = M;
	tmCountPtr->K = K;
	tmCountPtr->N = N;
	if ( Kmax < 0 )
	{
		tmCountPtr->Kmax = K;
	}
	else
	{
		tmCountPtr->Kmax = Kmax;
	}
	tmCountPtr->c = c;

	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

void tmcountFREE
	(
		TMCount *  tmCountPtr
	)
{
	int     N;
	int **  c;

	N = tmCountPtr->N;
	c = tmCountPtr->c;

	{
		int  i;

		for ( i = 0; i < N; i ++ )
		{
			free( (void *) (c[ i ]) );
		}
	}

	free( (void *) c );

	tmCountPtr->M = 0;
	tmCountPtr->K = 0;
	tmCountPtr->N = 0;
	tmCountPtr->Kmax = 0;
	tmCountPtr->c = (int **) NULL;

	return;

}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

void tmcountCLEAR
	(
		TMCount *  tmCountPtr
	)
{
	int     N;
	int **  c;

	N = tmCountPtr->N;
	c = tmCountPtr->c;

	{
		int  i;

		for ( i = 0; i < N; i ++ )
		{
			int *  c_i_;
			int    j;

			c_i_ = c[ i ];

			for ( j = 0; j < N; j ++ )
			{
				c_i_[ j ] = 0;
			}
		}
	}

	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

void tmcountINCREMENT
	(
		TMCount *  tmCountPtr,
		const int  Si,
		const int  Sj
	)
{
	int  N;

	N = tmCountPtr->N;

	assert( ( Si >= 0 ) && ( Si < N ) );
	assert( ( Sj >= 0 ) && ( Sj < N ) );

	tmCountPtr->c[ Si ][ Sj ] += 1;

	return;
}

/*==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+===*/

