/*
 * =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
 
Copyright (c) 2010, Kornel Laskowski
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of
      conditions and the following disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of Sigtactica Research or of the Royal Institute of Technology (KTH) or of
      Carnegie Mellon University nor the names of their contributors may be used to endorse or
      promote products derived from this software without specific prior written permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 ===+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

#include <stdlib.h>
#include <assert.h>
#include <math.h>
#include <float.h>
#include "ran1.h"
#include "tm.h"

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

void tmALLOC
	(
		TM *       tmPtr,
		const int  M,
		const int  K,
		const int  Kmax
	)
{
	int        N;
	double **  p;

	assert( M > 1 );
	assert( K > 0 );

	N = (int) pow( (double) M, (double) K );

	p = (double **) malloc( N * sizeof( double * ) );
	assert( p != (double **) NULL );

	{
		int  i;

		for ( i = 0; i < N; i ++ )
		{
			double *  p_i_;

			p_i_ = (double *) malloc( N * sizeof( double ) );
			assert( p_i_ != (double *) NULL );

			p[ i ] = p_i_;
		}
	}

	tmPtr->M = M;
	tmPtr->K = K;
	tmPtr->N = N;
	if ( Kmax < 0 )
	{
		tmPtr->Kmax = K;
	}
	else
	{
		tmPtr->Kmax = Kmax;
	}
	tmPtr->p = p;

	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

void tmFREE
	(
		TM *  tmPtr
	)
{
	int        N;
	double **  p;

	N = tmPtr->N;
	p = tmPtr->p;

	{
		int  i;

		for ( i = 0; i < N; i ++ )
		{
			free( (void *) (p[ i ]) );
		}
	}

	free( (void *) p );

	tmPtr->M = 0;
	tmPtr->K = 0;
	tmPtr->N = 0;
	tmPtr->Kmax = 0;
	tmPtr->p = (double **) NULL;

	return;

}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

void tmCLEAR
	(
		TM *  tmPtr
	)
{
	int        N;
	double **  p;

	N = tmPtr->N;
	p = tmPtr->p;

	{
		int  i;

		for ( i = 0; i < N; i ++ )
		{
			double *  p_i_;
			int       j;

			p_i_ = p[ i ];

			for ( j = 0; j < N; j ++ )
			{
				p_i_[ j ] = 0.0;
			}
		}
	}

	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

double tmPROB
	(
		TM *       tmPtr,
		const int  Si,
		const int  Sj
	)
{
	int     N;
	double  prob;

	N = tmPtr->N;

	assert( ( Si >= 0 ) && ( Si < N ) );
	assert( ( Sj >= 0 ) && ( Sj < N ) );

	prob = tmPtr->p[ Si ][ Sj ];

	return prob;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

int tmPREDSTOCHASTIC
	(
		TM *       tmPtr,
		const int  Si
	)
{
	int       N;
	double *  p_Si_;
	int       predSj;

	N = tmPtr->N;
	p_Si_ = tmPtr->p[ Si ];

	predSj = -1;
	while ( predSj == -1 )
	{
		double  uniformDeviate;
		double  lowerCumulativeBound;
		int     Sj;

		uniformDeviate = ran1( idum );

		lowerCumulativeBound = 0.0;
		for ( Sj = 0; Sj < N; Sj ++ )
		{
			double  upperCumulativeBound;

			upperCumulativeBound = lowerCumulativeBound + p_Si_[ Sj ];

			if ( uniformDeviate < upperCumulativeBound )
			{
				if ( uniformDeviate >= lowerCumulativeBound )
				{
					predSj = Sj;
					break;
				}
			}
		}
	}

	return predSj;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+-- */

int tmPREDDETERMINISTIC
	(
		TM *       tmPtr,
		const int  Si
	)
{
	int       N;
	double *  p_Si_;
	double    predSjProb;
	int       predSj;
	int       Sj;

	N = tmPtr->N;
	p_Si_ = tmPtr->p[ Si ];

	predSjProb = -DBL_MIN;
	predSj = -1;
	for ( Sj = 0; Sj < N; Sj ++ )
	{
		double  SjProb;

		SjProb = p_Si_[ Sj ];

		if ( SjProb > predSjProb )
		{
			predSjProb = SjProb;
			predSj = Sj;
		}
	}

	assert( predSj > -1 );

	return predSj;
}

/* =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

