/*
 * =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
 
Copyright (c) 2007-2010, Kornel Laskowski
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of
      conditions and the following disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of Sigtactica Research or of the Royal Institute of Technology (KTH) or of
      Carnegie Mellon University nor the names of their contributors may be used to endorse or
      promote products derived from this software without specific prior written permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 ===+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include "FileName.h"

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7-- */

void FileNameCREATE
	(
		char **       fileNamePtr,
		const char *  dirName,
		const char *  mId,
		const char *  chanId,
		const char *  extension
	)
{
	int  fileNameLen;

	fileNameLen = strlen( dirName ) + 1
		+ strlen( mId ) + 1
		+ strlen( chanId ) + 1
		+ strlen( extension ) + 1;

	*fileNamePtr = (char *) malloc( fileNameLen * sizeof( char ) );
	assert( *fileNamePtr != (char *) NULL );
	sprintf( *fileNamePtr, "%s/%s_%s.%s", dirName, mId, chanId, extension );

	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7-- */

void FileNameDESTROY
	(
		char **  fileNamePtr
	)
{
	free( (void *) (*fileNamePtr) );
	*fileNamePtr = (char *) NULL;

	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7-- */

void FileNameGETLIST
	(
		const char *  locationPathName,
		const char *  extensionStr,
		char ***      fileNameTabPtr,
		int *         nFilesPtr
	)
{
	int          extensionStrLen;
	int          locationPathNameLen;
	struct stat  statBuf;
	char **      fileNameTab;
	int          nFiles;

	extensionStrLen = strlen( extensionStr );
	locationPathNameLen = strlen( locationPathName );

	if ( stat( locationPathName, &statBuf ) != 0 )
	{
		nFiles = 0;
		fileNameTab = (char **) NULL;
	}
	else if ( S_ISREG( statBuf.st_mode ) )
	{
		/* one file */

		if
			(
				strncmp
					(
						locationPathName + locationPathNameLen - extensionStrLen,
						extensionStr,
						extensionStrLen
					)
				== 0
			)
		{
			nFiles = 1;
			fileNameTab = (char **) malloc( nFiles * sizeof( char * ) );
			assert( fileNameTab != (char **) NULL );

			fileNameTab[ 0 ] = (char *) malloc( (locationPathNameLen + 1) * sizeof( char ) );
			assert( fileNameTab[ 0 ] != (char *) NULL );
			strcpy( fileNameTab[ 0 ], locationPathName );
		}
		else
		{
			nFiles = 0;
			fileNameTab = (char **) NULL;
		}
	}
	else if ( S_ISDIR( statBuf.st_mode ) )
	{
		/* a directory */

		DIR *            dirPtr;
		struct dirent *  direntPtr;

		nFiles = 0;

		dirPtr = opendir( locationPathName );
		assert( dirPtr != (DIR *) NULL );

		while ( ( direntPtr = readdir( dirPtr ) ) != (struct dirent *) NULL )
		{
			char *  fileName;
			int     fileNameLen;

			fileName = direntPtr->d_name;
			fileNameLen = strlen( fileName );

			if
				(
					strncmp
						(
							fileName + fileNameLen - extensionStrLen,
							extensionStr,
							extensionStrLen
						)
					== 0
				)
			{
				nFiles ++;
			}
		}

		closedir( dirPtr );

		if ( nFiles > 0 )
		{
			int  fileIdx;

			fileNameTab = (char **) malloc( nFiles * sizeof( char * ) );
			assert( fileNameTab != (char **) NULL );

			fileIdx = 0;

			dirPtr = opendir( locationPathName );
			assert( dirPtr != (DIR *) NULL );

			while ( ( direntPtr = readdir( dirPtr ) ) != (struct dirent *) NULL )
			{
				char *  fileName;
				int     fileNameLen;

				fileName = direntPtr->d_name;
				fileNameLen = strlen( fileName );

				if 
					( 
						strncmp
							(
								fileName + fileNameLen - extensionStrLen,
								extensionStr,
								extensionStrLen
							)
						== 0
					)
				{
					assert( fileIdx < nFiles );

					fileNameTab[ fileIdx ] = (char *)
						malloc( (locationPathNameLen + 1 + fileNameLen + 1) * sizeof( char ) );
					assert( fileNameTab[ fileIdx ] != (char *) NULL );
					sprintf( fileNameTab[ fileIdx ], "%s/%s", locationPathName, fileName );

					fileIdx ++;
				}
			}

			closedir( dirPtr );
		}
		else
		{
			nFiles = 0;
			fileNameTab = (char **) NULL;
		}
	}
	else
	{
		nFiles = 0;
		fileNameTab = (char **) NULL;
	}

	*nFilesPtr = nFiles;
	*fileNameTabPtr = fileNameTab;
/*
	printf( "RETURNING %d nFiles\n", nFiles );
*/
	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7-- */

void FileNameFREELIST
	(
		char **    fileNameTab,
		const int  nFiles
	)
{
	int  fileIdx;

	for ( fileIdx = 0; fileIdx < nFiles; fileIdx ++ )
	{
		free( (void *) (fileNameTab[ fileIdx ]) );
	}

	free( (void *) fileNameTab );

	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7-- */

