/*
 * =+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
 
Copyright (c) 2007-2010, Kornel Laskowski
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of
      conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of
      conditions and the following disclaimer in the documentation and/or other materials provided
      with the distribution.
    * Neither the name of Sigtactica Research or of the Royal Institute of Technology (KTH) or of
      Carnegie Mellon University nor the names of their contributors may be used to endorse or
      promote products derived from this software without specific prior written permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 ===+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+== */

#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <stdio.h>
#include "sutils.h"
#include "DblMatrix.h"

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7-- */

void DblMatrixALLOC
	(
		double ***  matrixPtrPtrPtr,
		const int   nRow,
		const int   nCol
	)
{
	int  rowIdx;

	assert( *matrixPtrPtrPtr == (double **) NULL );
	assert( nRow > 0 );
	assert( nCol > 0 );

	*matrixPtrPtrPtr = (double **) malloc( nRow * sizeof( double * ) );
	assert( *matrixPtrPtrPtr != (double **) NULL );
	for ( rowIdx = 0; rowIdx < nRow; rowIdx ++ )
	{
		(*matrixPtrPtrPtr)[ rowIdx ] = (double *)
			malloc( nCol * sizeof( double ) );
		assert( (*matrixPtrPtrPtr)[ rowIdx ] != (double *) NULL );
		memset
			(
				(void *) ((*matrixPtrPtrPtr)[ rowIdx ]),
				0,
				nCol * sizeof( double )
			);
	}

	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7-- */

void DblMatrixFREE
	(
		double ***  matrixPtrPtrPtr,
		const int   nRow,
		const int   nCol
	)
{
	int  rowIdx;

	assert( *matrixPtrPtrPtr != (double **) NULL );
	assert( nRow > 0 );

	for ( rowIdx = 0; rowIdx < nRow; rowIdx ++ )
	{
		free( (void *) (*matrixPtrPtrPtr)[ rowIdx ] );
	}
	free( (void *) (*matrixPtrPtrPtr) );

	*matrixPtrPtrPtr = (double **) NULL;

	return;
}

/* -+----1----+----2----+----3----+----4----+----5----+----6----+----7-- */

void DblMatrixREAD
	(
		const char *  fileName,
		double ***    matrixPtr,
		int *         nRowPtr,
		int *         nColPtr
	)
{
	FILE *        filePtr;
	#define       LINEBUFFERLEN 1024
	char          lineBuffer[ LINEBUFFERLEN ];
	int           nRow;
	int           nCol;
	const char *  tokenSeparator = " \t,\n";

	*matrixPtr = (double **) NULL;

	filePtr = fopen( fileName, "r" );
	assert( filePtr != (FILE *) NULL );

	nRow = 0;
	nCol = -1;
	while ( fgets( lineBuffer, LINEBUFFERLEN, filePtr ) != (char *) NULL )
	{
		char *  tokenPtr;

		tokenPtr = strtok( lineBuffer, tokenSeparator );
		if ( tokenPtr == (char *) NULL )
		{
			/* there are no tokens in this line */
		}
		else
		{
			int  myNFields;

			myNFields = 1; /* one strtok() down */

			while ( strtok( (char *) NULL, tokenSeparator ) != (char *) NULL )
			{
				myNFields ++;
			}

			if ( nCol == -1 )
			{
				nCol = myNFields;
			}
			else
			{
				assert( nCol == myNFields );
			}

			nRow ++;
		}
	}
	fclose( filePtr );

	DblMatrixALLOC( matrixPtr, nRow, nCol );

	filePtr = fopen( fileName, "r" );
	assert( filePtr != (FILE *) NULL );

	nRow = 0;
	while ( fgets( lineBuffer, LINEBUFFERLEN, filePtr ) != (char *) NULL )
	{
		char *  tokenPtr;

		nCol = 0;
		tokenPtr = strtok( lineBuffer, tokenSeparator );
		if ( tokenPtr == (char *) NULL )
		{
			/* there are no tokens in this line */
		}
		else
		{
			do
			{
				(*matrixPtr)[ nRow ][ nCol ] = str2dbl( tokenPtr );
				nCol ++;
			}
			while ( ( tokenPtr = strtok( (char *) NULL, tokenSeparator ) ) != (char *) NULL );
		}

		nRow ++;
	}
	fclose( filePtr );

	*nRowPtr = nRow;
	*nColPtr = nCol;
 
	return;
}
