% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
% 
% Copyright (c) 2010, Kornel Laskowski
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without modification, are permitted
% provided that the following conditions are met:
%
%    * Redistributions of source code must retain the above copyright notice, this list of
%      conditions and the following disclaimer.
%    * Redistributions in binary form must reproduce the above copyright notice, this list of
%      conditions and the following disclaimer in the documentation and/or other materials provided
%      with the distribution.
%    * Neither the name of Sigtactica Research or of the Royal Institute of Technology (KTH) or of
%      Carnegie Mellon University nor the names of their contributors may be used to endorse or
%      promote products derived from this software without specific prior written permission.
% 
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
% IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
% FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
% DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
% DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
% IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
% OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%
% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

%
% Encode binary Q into a single number per instant.
%

[T,K] = size(Q);
encoding = zeros(K,1);
for k=1:K
	encoding(k) = 2^(k-1);
end
encodedQ = Q * encoding;

%
% Create and zero the transition probability matrix.
%

N = sum(encoding) + 1;
clear a;
a = zeros(N,N);

%
% Accumulate counts in the matrix.
%

qPrev = 0;
for t=1:T
	q = encodedQ(t);
	a(qPrev+1,q+1) = a(qPrev+1,q+1) + 1;
	qPrev = q;
end

%
% Normalize a counts to be probabilities.
%

sumARows = sum(a,2);
zeroIdx = find(sumARows == 0);
a(zeroIdx,:) = 1;
sumARows = sum(a,2);
a = a ./ (sumARows * ones(1,N));

%
% Share unkFraction probability mass for unseen events.
%

for i=1:N
	nZero = 0;
	for j=1:N
		if a(i,j) == 0
			nZero = nZero + 1;
		end
	end
	if nZero > 0
		for j=1:N
			if a(i,j) == 0
				a(i,j) = unkFraction / nZero;
			else
				a(i,j) = a(i,j) * ( 1 - unkFraction );
			end
		end
	end
end

%
% Re-normalize a counts to be probabilities.
%

sumARows = sum(a,2);
a = a ./ (sumARows * ones(1,N));

%
% Score Q against the model.
%

qPrev = 0;
qProb = zeros(T,1);
for t=1:T
	q = encodedQ(t);
	qProb(t) = a(qPrev+1,q+1);
	qPrev = q;
end

qNegLogProb = -log2(qProb)/K;

