% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
% 
% Copyright (c) 2010, Kornel Laskowski
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without modification, are permitted
% provided that the following conditions are met:
%
%    * Redistributions of source code must retain the above copyright notice, this list of
%      conditions and the following disclaimer.
%    * Redistributions in binary form must reproduce the above copyright notice, this list of
%      conditions and the following disclaimer in the documentation and/or other materials provided
%      with the distribution.
%    * Neither the name of Sigtactica Research or of the Royal Institute of Technology (KTH) or of
%      Carnegie Mellon University nor the names of their contributors may be used to endorse or
%      promote products derived from this software without specific prior written permission.
% 
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
% IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
% FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
% DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
% DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
% IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
% OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%
% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

meetIdList = {
	'Bdb001',
	'Bed002',
	'Bed003',
	'Bed004',
	'Bed005',
	'Bed006',
	'Bed008',
	'Bed009',
	'Bed010',
	'Bed011',
	'Bed012',
	'Bed013',
	'Bed014',
	'Bed015',
	'Bed016',
	'Bed017',
	'Bmr001',
	'Bmr002',
	'Bmr003',
	'Bmr005',
	'Bmr006',
	'Bmr007',
	'Bmr008',
	'Bmr009',
	'Bmr010',
	'Bmr011',
	'Bmr012',
	'Bmr013',
	'Bmr014',
	'Bmr015',
	'Bmr016',
	'Bmr018',
	'Bmr019',
	'Bmr020',
	'Bmr021',
	'Bmr022',
	'Bmr023',
	'Bmr024',
	'Bmr025',
	'Bmr026',
	'Bmr027',
	'Bmr028',
	'Bmr029',
	'Bmr030',
	'Bmr031',
	'Bns001',
	'Bns002',
	'Bns003',
	'Bro003',
	'Bro004',
	'Bro005',
	'Bro007',
	'Bro008',
	'Bro010',
	'Bro011',
	'Bro012',
	'Bro013',
	'Bro014',
	'Bro015',
	'Bro016',
	'Bro017',
	'Bro018',
	'Bro019',
	'Bro021',
	'Bro022',
	'Bro023',
	'Bro024',
	'Bro025',
	'Bro026',
	'Bro027',
	'Bro028',
	'Bsr001',
	'Btr001',
	'Btr002',
	'Buw001'
};

R = length(meetIdList);

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

PPTABLE = zeros(2,2);

modelCD  = 1;
% modelUI  = 4;

ALL = 0;
SUB = 1;

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

unkFraction = 0.000001;

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngramOracle_CD;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelCD,1+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngramOracle_CD;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelCD,1+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

