% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0
% 
% Copyright (c) 2010, Kornel Laskowski
% All rights reserved.
%
% Redistribution and use in source and binary forms, with or without modification, are permitted
% provided that the following conditions are met:
%
%    * Redistributions of source code must retain the above copyright notice, this list of
%      conditions and the following disclaimer.
%    * Redistributions in binary form must reproduce the above copyright notice, this list of
%      conditions and the following disclaimer in the documentation and/or other materials provided
%      with the distribution.
%    * Neither the name of Sigtactica Research or of the Royal Institute of Technology (KTH) or of
%      Carnegie Mellon University nor the names of their contributors may be used to endorse or
%      promote products derived from this software without specific prior written permission.
% 
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
% IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
% FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
% DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
% DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
% IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
% OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%
% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

meetIdList = {
	'Bdb001',
	'Bed002',
	'Bed003',
	'Bed004',
	'Bed005',
	'Bed006',
	'Bed008',
	'Bed009',
	'Bed010',
	'Bed011',
	'Bed012',
	'Bed013',
	'Bed014',
	'Bed015',
	'Bed016',
	'Bed017',
	'Bmr001',
	'Bmr002',
	'Bmr003',
	'Bmr005',
	'Bmr006',
	'Bmr007',
	'Bmr008',
	'Bmr009',
	'Bmr010',
	'Bmr011',
	'Bmr012',
	'Bmr013',
	'Bmr014',
	'Bmr015',
	'Bmr016',
	'Bmr018',
	'Bmr019',
	'Bmr020',
	'Bmr021',
	'Bmr022',
	'Bmr023',
	'Bmr024',
	'Bmr025',
	'Bmr026',
	'Bmr027',
	'Bmr028',
	'Bmr029',
	'Bmr030',
	'Bmr031',
	'Bns001',
	'Bns002',
	'Bns003',
	'Bro003',
	'Bro004',
	'Bro005',
	'Bro007',
	'Bro008',
	'Bro010',
	'Bro011',
	'Bro012',
	'Bro013',
	'Bro014',
	'Bro015',
	'Bro016',
	'Bro017',
	'Bro018',
	'Bro019',
	'Bro021',
	'Bro022',
	'Bro023',
	'Bro024',
	'Bro025',
	'Bro026',
	'Bro027',
	'Bro028',
	'Bsr001',
	'Btr001',
	'Btr002',
	'Buw001'
};

R = length(meetIdList);

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

PPTABLE = zeros(4,8);

modelCD  = 1;
modelCIk = 2;
modelUIk = 3;
modelUI  = 4;

splitAB = 1;
splitBA = 3;
splitCD = 5;
splitDC = 7;

ALL = 0;
SUB = 1;

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

unkFraction = 0.000001;

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CD_AB;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelCD,splitAB+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CD_AB;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelCD,splitAB+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CIk_AB;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelCIk,splitAB+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CIk_AB;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelCIk,splitAB+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UIk_AB;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelUIk,splitAB+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UIk_AB;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelUIk,splitAB+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UI_AB;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelUI,splitAB+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UI_AB;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelUI,splitAB+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CD_BA;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelCD,splitBA+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CD_BA;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelCD,splitBA+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CIk_BA;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelCIk,splitBA+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CIk_BA;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelCIk,splitBA+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UIk_BA;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelUIk,splitBA+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UIk_BA;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelUIk,splitBA+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UI_BA;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelUI,splitBA+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));
% THIS WAS WRONG

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UI_BA;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelUI,splitBA+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CD_CD;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelCD,splitCD+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CD_CD;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelCD,splitCD+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CIk_CD;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelCIk,splitCD+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CIk_CD;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelCIk,splitCD+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UIk_CD;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelUIk,splitCD+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UIk_CD;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelUIk,splitCD+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UI_CD;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelUI,splitCD+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UI_CD;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelUI,splitCD+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CD_DC;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelCD,splitDC+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CD_DC;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelCD,splitDC+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CIk_DC;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelCIk,splitDC+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_CIk_DC;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelCIk,splitDC+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UIk_DC;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelUIk,splitDC+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UIk_DC;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelUIk,splitDC+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UI_DC;
	expQNegLogProb = [ expQNegLogProb; qNegLogProb ];
end

PPTABLE(modelUI,splitDC+ALL) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% --+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9----+----0

expQNegLogProb = [];

for r=1:R
	QFileName = sprintf('../lex.Q/%s.Q',meetIdList{r});
	Q = textread(QFileName);
	ngram_UI_DC;
	subIdx = find([0; encodedQ(1:(end-1))] ~= encodedQ);
	expQNegLogProb = [ expQNegLogProb; qNegLogProb(subIdx) ];
end

PPTABLE(modelUI,splitDC+SUB) = 2^(sum(expQNegLogProb)/length(expQNegLogProb));

% ==+====1====+====2====+====3====+====4====+====5====+====6====+====7====+====8====+====9====+====0

