/*
 * Decompiled with CFR 0.152.
 */
package dcube.hadoop;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class RemoveBMR {

    public static class RemoveBReducer
    extends Reducer<NullWritable, Text, NullWritable, Text> {
    }

    public static class RemoveBMapper
    extends Mapper<Object, Text, NullWritable, Text> {
        private int modeToRemove;
        private boolean[] attValesToRemove;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.modeToRemove = context.getConfiguration().getInt("PARAM_MODE_TO_REMOVE", 0);
            int n = context.getConfiguration().getInt("PARAM_CARDINALITY" + this.modeToRemove, 0);
            this.attValesToRemove = new boolean[n];
            Path[] pathArray = DistributedCache.getLocalCacheFiles((Configuration)context.getConfiguration());
            if (pathArray != null && pathArray.length > 0) {
                for (Path path : pathArray) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(path.toString()), 0x800000));
                    try {
                        while (true) {
                            this.attValesToRemove[objectInputStream.readInt()] = true;
                        }
                    }
                    catch (EOFException eOFException) {
                        objectInputStream.close();
                    }
                }
            }
        }

        public void map(Object object, Text text, Mapper.Context context) throws IOException, InterruptedException {
            String[] stringArray = text.toString().split(",");
            if (!this.attValesToRemove[Integer.valueOf(stringArray[this.modeToRemove])]) {
                context.write((Object)NullWritable.get(), (Object)text);
            }
        }
    }
}

