/*
 * Decompiled with CFR 0.152.
 */
package dcube.hadoop;

import dcube.Arithmetic;
import dcube.BlockInfo;
import dcube.BlockIterInfo;
import dcube.DensityMeasure;
import dcube.Geometric;
import dcube.IDensityMeasure;
import dcube.Suspiciousness;
import dcube.hadoop.AttValMassMR;
import dcube.hadoop.CardinalityMR;
import dcube.hadoop.ComputeBOriMR;
import dcube.hadoop.EvaluateMR;
import dcube.hadoop.RemoveBMR;
import dcube.hadoop.RemoveRMR;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class ProposedHadoop {
    private String originalPath;
    private String outputPath;
    private String logPath;
    private String defaultCurrentRPath;
    private String defaultBlockBPath;
    private String tempPath;
    private String distributedCachePath;
    public String currentRPath;
    public String blockBPath;
    private int dimension;
    private int reducerNum;
    private int[] cardinalities;
    private int[][] attValMasses;
    private long massR;
    private long massRori;
    private Configuration conf;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 5) {
            ProposedHadoop.printError();
            System.exit(-1);
        }
        String string = stringArray[0];
        System.out.println("input_path: " + string);
        String string2 = stringArray[1];
        System.out.println("output_path: " + string2);
        int n = Integer.valueOf(stringArray[2]);
        System.out.println("dimension: " + n);
        DensityMeasure densityMeasure = null;
        if (stringArray[3].compareToIgnoreCase("ARI") == 0) {
            densityMeasure = DensityMeasure.Arithmetic;
        } else if (stringArray[3].compareToIgnoreCase("GEO") == 0) {
            densityMeasure = DensityMeasure.Geometric;
        } else if (stringArray[3].compareToIgnoreCase("SUSP") == 0) {
            densityMeasure = DensityMeasure.Suspiciousness;
        } else {
            System.err.println("Unknown Density Measure");
            ProposedHadoop.printError();
            System.exit(-1);
        }
        System.out.println("density_measure: " + stringArray[3]);
        int n2 = 0;
        if (stringArray[4].compareToIgnoreCase("CARDINALITY") == 0) {
            n2 = 0;
        } else if (stringArray[4].compareToIgnoreCase("DENSITY") == 0) {
            n2 = 1;
        } else {
            System.err.println("Unknown Policy");
            ProposedHadoop.printError();
            System.exit(-1);
        }
        System.out.println("policy: " + stringArray[4]);
        double d = Double.valueOf(stringArray[5]);
        System.out.println("mass_threshold:" + d);
        if (d < 1.0) {
            System.err.println("Mass_threshold should be greater than or equal to one");
            ProposedHadoop.printError();
            System.exit(-1);
        }
        int n3 = Integer.valueOf(stringArray[6]);
        System.out.println("num_of_blocks: " + n3);
        int n4 = Integer.valueOf(stringArray[7]);
        System.out.println("num_of_reducers: " + n4);
        String string3 = stringArray[8];
        System.out.println("log path (local): " + string3);
        File file = new File(string3);
        try {
            file.mkdir();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.setOut(new PrintStream(new File(string3 + "/log.txt")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("input path: " + string);
        System.out.println("output path: " + string2);
        System.out.println("dimension: " + n);
        System.out.println("densityMeasure: " + stringArray[3]);
        System.out.println("policy: " + stringArray[4]);
        System.out.println("mass_threshold: " + d);
        System.out.println("num_of_blocks: " + n3);
        System.out.println("reducerNum: " + n4);
        System.out.println("log path (local): " + string3);
        System.out.println();
        System.out.println("running the algorithm...");
        ProposedHadoop proposedHadoop = new ProposedHadoop(string, string2, string3, n, n4);
        proposedHadoop.run(n3, densityMeasure, n2, d);
    }

    private static void printError() {
        System.err.println("Usage: run_hadoop.sh input_path output_path dimension density_measure policy mass_threshold num_of_blocks num_of_reducers log_path");
        System.err.println("Density_measure should be one of [ari, geo, susp]");
        System.err.println("Policy should be one of [density, cardinality]");
        System.err.println("Mass_threshold should be a number greater than or equal to one");
    }

    public void run(int n, DensityMeasure densityMeasure, int n2, double d) throws Exception {
        long l = System.currentTimeMillis();
        this.copyOriTesnor();
        this.initialize();
        IDensityMeasure iDensityMeasure = null;
        if (densityMeasure == DensityMeasure.Suspiciousness) {
            iDensityMeasure = new Suspiciousness();
        } else if (densityMeasure == DensityMeasure.Arithmetic) {
            iDensityMeasure = new Arithmetic();
        } else if (densityMeasure == DensityMeasure.Geometric) {
            iDensityMeasure = new Geometric();
        } else {
            System.out.println("Error: Unknown Density IMeasure");
        }
        iDensityMeasure.initialize(this.getDimension(), this.getCardinalities(), this.getMass(TensorType.OriginalR));
        LinkedList<BlockInfo> linkedList = new LinkedList<BlockInfo>();
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            BlockInfo blockInfo = this.findOneBlock(i, densityMeasure, n2, d);
            d2 = Math.max(d2, this.removeAndEvaluateBlock(i, blockInfo, iDensityMeasure, i == n - 1));
            linkedList.add(blockInfo);
        }
        System.out.println("Running time: " + ((double)(System.currentTimeMillis() - l) + 0.0) / 1000.0 + " seconds");
        l = System.currentTimeMillis();
        System.out.println("Writing outputs...");
        this.writeOutput(this.outputPath, linkedList);
        System.out.println("Outputs were written. " + ((double)(System.currentTimeMillis() - l) + 0.0) / 1000.0 + " seconds was taken.");
        System.out.println("Removing temporary files...");
        this.remove(n);
        System.out.println("Temporary files were removed.");
    }

    private void remove(int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < n; ++i) {
            linkedList.add(this.getBlockInfoFullPath(i));
            linkedList.add(this.getOrderingFullPath(i));
        }
        for (String string : linkedList) {
            if (!new File(string).exists()) continue;
            new File(string).delete();
        }
    }

    private String getTempLocalFilePath() {
        String string;
        while (new File(string = "DECUBE_" + new Random().nextInt()).exists()) {
        }
        return string;
    }

    private BlockInfo findOneBlock(int n, DensityMeasure densityMeasure, int n2, double d) throws Exception {
        int n3;
        int n4 = this.getDimension();
        int[] nArray = this.getCardinalities();
        long l = this.getMass(TensorType.CurrentR);
        int[][] nArray2 = ProposedHadoop.createModeToAttVals(n4, nArray);
        int[][] nArray3 = this.getAttValMasses();
        int[] nArray4 = (int[])nArray.clone();
        int[] nArray5 = new int[n4];
        int n5 = ProposedHadoop.sumOfCarndinalities(n4, nArray);
        IDensityMeasure iDensityMeasure = null;
        if (densityMeasure == DensityMeasure.Suspiciousness) {
            iDensityMeasure = new Suspiciousness();
        } else if (densityMeasure == DensityMeasure.Arithmetic) {
            iDensityMeasure = new Arithmetic();
        } else if (densityMeasure == DensityMeasure.Geometric) {
            iDensityMeasure = new Geometric();
        } else {
            System.out.println("Error: Unknown Density IMeasure");
        }
        this.copyBlock();
        BlockIterInfo blockIterInfo = new BlockIterInfo(nArray, BlockIterInfo.properBufferUsage(n5), this.getOrderingFullPath(n));
        int n6 = 0;
        double d2 = iDensityMeasure.initialize(this.getDimension(), this.getCardinalities(), this.getMass(TensorType.CurrentR));
        int n7 = 0;
        while (n7 < n5) {
            int n8;
            n3 = 0;
            double d3 = -1.7976931348623157E308;
            for (int i = 0; i < n4; ++i) {
                if (nArray4[i] <= 0) continue;
                if (n2 == 0) {
                    int n9 = nArray4[i];
                    if (!((double)n9 >= d3)) continue;
                    n3 = i;
                    d3 = n9;
                    continue;
                }
                if (n2 == 1) {
                    double d4 = (double)l * d / (double)nArray4[i];
                    int n10 = 0;
                    long l2 = 0L;
                    int[] nArray6 = nArray3[i];
                    int[] nArray7 = nArray2[i];
                    for (int j = nArray5[i]; j < nArray[i]; ++j) {
                        int n11 = nArray7[j];
                        if (!((double)nArray6[n11] <= d4)) continue;
                        ++n10;
                        l2 += (long)nArray6[n11];
                    }
                    if (n10 >= 1) {
                        double d5 = iDensityMeasure.ifRemoved(i, n10, l2);
                        if (!(d5 >= d3)) continue;
                        n3 = i;
                        d3 = d5;
                        continue;
                    }
                    System.out.println("Sanity Check!");
                    continue;
                }
                System.out.println("ERROR");
            }
            double d6 = (double)l * d / (double)nArray4[n3];
            int[] nArray8 = nArray3[n3];
            boolean[] blArray = new boolean[nArray[n3]];
            ProposedHadoop.sort(nArray2[n3], nArray3[n3], nArray5[n3], nArray[n3] - 1);
            int[] nArray9 = nArray2[n3];
            for (int i = nArray5[n3]; i < nArray[n3] && (double)nArray8[n8 = nArray9[i]] <= d6; ++i) {
                l -= (long)nArray8[n8];
                double d7 = iDensityMeasure.remove(n3, nArray8[n8]);
                if (d7 > d2) {
                    d2 = d7;
                    n6 = n7 + 1;
                }
                int n12 = n3;
                nArray5[n12] = nArray5[n12] + 1;
                int n13 = n3;
                nArray4[n13] = nArray4[n13] - 1;
                blockIterInfo.addIterInfo((byte)n3, n8);
                ++n7;
                blArray[n8] = true;
            }
            this.removeAndUpdateAttValMasses(n3, blArray, nArray3);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.attValMasses[n3] = new int[0];
        }
        return blockIterInfo.returnBlock(n6, this.getBlockInfoFullPath(n));
    }

    private static int sumOfCarndinalities(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i];
        }
        return n2;
    }

    private static int[][] createModeToAttVals(int n, int[] nArray) {
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = new int[nArray[i]];
            for (int j = 0; j < nArray[i]; ++j) {
                nArray2[j] = j;
            }
            nArrayArray[i] = nArray2;
        }
        return nArrayArray;
    }

    public static void sort(int[] nArray, int[] nArray2) {
        ProposedHadoop.sort(nArray, nArray2, 0, nArray.length - 1);
    }

    public static void sort(int[] nArray, int[] nArray2, int n, int n2) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (n >= n2) {
            return;
        }
        int n3 = n + (n2 - n) / 2;
        int n4 = nArray2[nArray[n3]];
        int n5 = n;
        int n6 = n2;
        while (n5 <= n6) {
            while (nArray2[nArray[n5]] < n4) {
                ++n5;
            }
            while (nArray2[nArray[n6]] > n4) {
                --n6;
            }
            if (n5 > n6) continue;
            int n7 = nArray[n5];
            nArray[n5] = nArray[n6];
            nArray[n6] = n7;
            ++n5;
            --n6;
        }
        if (n < n6) {
            ProposedHadoop.sort(nArray, nArray2, n, n6);
        }
        if (n2 > n5) {
            ProposedHadoop.sort(nArray, nArray2, n5, n2);
        }
    }

    public ProposedHadoop(String string, String string2, String string3, int n, int n2) throws Exception {
        this.originalPath = string;
        this.outputPath = string2;
        this.logPath = string3;
        this.dimension = n;
        this.cardinalities = new int[n];
        this.attValMasses = new int[n][];
        this.reducerNum = n2;
        this.defaultCurrentRPath = string2 + "/disk_cur";
        this.defaultBlockBPath = string2 + "/disk_block";
        this.tempPath = string2 + "/temp";
        this.currentRPath = string2 + "/disk_cur";
        this.blockBPath = string2 + "/disk_block";
        this.distributedCachePath = string2 + "/cache";
        this.conf = new Configuration();
        this.conf.setInt("PARAM_DIMENSION", n);
        this.conf.setInt("PARAM_REDUCER_NUM", n2);
        long l = this.getFileSize(this.originalPath);
        this.conf.setBoolean("mapred.map.tasks.speculative.execution", false);
        this.conf.setInt("mapred.map.tasks", n2);
        this.conf.setLong("mapred.min.split.size", l / (long)n2 + 1L);
        this.conf.setLong("mapred.max.split.size", l / (long)n2 + 1L);
    }

    private long getFileSize(String string) throws IOException {
        FileStatus[] fileStatusArray;
        long l = 0L;
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        for (FileStatus fileStatus : fileStatusArray = fileSystem.listStatus(new Path(string))) {
            l += fileStatus.getLen();
        }
        return l;
    }

    public void initialize() throws Exception {
        this.runCardinalityJob();
        this.readCardinalities();
        this.runAttValMassJob(this.originalPath);
        this.readAttValMasses(this.attValMasses);
        this.massRori = this.massR = this.computeMass(this.attValMasses);
    }

    private void runCardinalityJob() throws Exception {
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        if (fileSystem.exists(new Path(this.tempPath))) {
            fileSystem.delete(new Path(this.tempPath), true);
        }
        Job job = new Job(this.conf, "ModeLength");
        job.setJarByClass(CardinalityMR.class);
        job.setMapperClass(CardinalityMR.CardinalityMapper.class);
        job.setNumReduceTasks(1);
        job.setReducerClass(CardinalityMR.CardinalityReducer.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(this.originalPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(this.tempPath));
        job.waitForCompletion(true);
    }

    private void readCardinalities() throws Exception {
        FileStatus[] fileStatusArray;
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        String string = this.tempPath;
        for (FileStatus fileStatus : fileStatusArray = fileSystem.listStatus(new Path(string))) {
            String string2;
            String string3 = fileStatus.getPath().getName();
            if (!string3.contains("part")) continue;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(new Path(string + "/" + string3))));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                String[] stringArray = string2.split(",");
                int n2 = Integer.valueOf(stringArray[0]);
                this.cardinalities[n2] = n = Integer.valueOf(stringArray[1]).intValue();
            }
            bufferedReader.close();
        }
        for (int i = 0; i < this.dimension; ++i) {
            this.conf.setInt("PARAM_CARDINALITY" + i, this.cardinalities[i]);
            System.out.println("mode lengh (mode=" + i + "): " + this.cardinalities[i]);
        }
    }

    protected long getMass(TensorType tensorType) {
        if (tensorType == TensorType.OriginalR) {
            return this.massRori;
        }
        return this.massR;
    }

    protected int[] getCardinalities() {
        return this.cardinalities;
    }

    protected int[][] getAttValMasses() {
        return this.attValMasses;
    }

    protected int getDimension() {
        return this.dimension;
    }

    protected void copyOriTesnor() throws IOException {
        this.currentRPath = this.originalPath;
    }

    protected void copyBlock() throws IOException, ClassNotFoundException, InterruptedException {
        this.blockBPath = this.currentRPath;
    }

    protected void removeAndUpdateAttValMasses(int n, boolean[] blArray, int[][] nArray) throws Exception {
        this.runRemoveBJob(n, blArray);
        this.runAttValMassJob(this.blockBPath);
        this.readAttValMasses(nArray);
    }

    public void runRemoveBJob(int n, boolean[] blArray) throws Exception {
        this.conf.setInt("PARAM_MODE_TO_REMOVE", n);
        String string = this.getTempLocalFilePath();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(string), 0x800000));
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            objectOutputStream.writeInt(i);
        }
        objectOutputStream.close();
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        fileSystem.copyFromLocalFile(true, true, new Path(string), new Path(this.distributedCachePath));
        if (fileSystem.exists(new Path(this.tempPath))) {
            fileSystem.delete(new Path(this.tempPath), true);
        }
        Job job = new Job(this.conf, "RemoveB");
        job.setJarByClass(RemoveBMR.class);
        job.setMapperClass(RemoveBMR.RemoveBMapper.class);
        job.setNumReduceTasks(0);
        job.setReducerClass(RemoveBMR.RemoveBReducer.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(this.blockBPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(this.tempPath));
        DistributedCache.addCacheFile((URI)new Path(this.distributedCachePath).toUri(), (Configuration)job.getConfiguration());
        job.waitForCompletion(true);
        this.blockBPath = this.defaultBlockBPath;
        if (fileSystem.exists(new Path(this.blockBPath))) {
            fileSystem.delete(new Path(this.blockBPath), true);
        }
        fileSystem.rename(new Path(this.tempPath), new Path(this.blockBPath));
    }

    public void runAttValMassJob(String string) throws Exception {
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        if (fileSystem.exists(new Path(this.tempPath))) {
            fileSystem.delete(new Path(this.tempPath), true);
        }
        Job job = new Job(this.conf, "AttValMass");
        job.setJarByClass(AttValMassMR.class);
        job.setMapperClass(AttValMassMR.AttValMassMapper.class);
        job.setNumReduceTasks(this.reducerNum);
        job.setReducerClass(AttValMassMR.AttValMassReducer.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(string));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(this.tempPath));
        job.waitForCompletion(true);
    }

    public void readAttValMasses(int[][] nArray) throws IOException {
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        String string = this.tempPath;
        FileStatus[] fileStatusArray = fileSystem.listStatus(new Path(string));
        for (int i = 0; i < this.dimension; ++i) {
            nArray[i] = null;
            nArray[i] = new int[this.cardinalities[i]];
        }
        for (FileStatus fileStatus : fileStatusArray) {
            String string2;
            String string3 = fileStatus.getPath().getName();
            if (!string3.contains("part")) continue;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(new Path(string + "/" + string3))));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                String[] stringArray = string2.split(",");
                int n2 = Integer.valueOf(stringArray[0]);
                int n3 = Integer.valueOf(stringArray[1]);
                nArray[n2][n3] = n = Integer.valueOf(stringArray[2]).intValue();
            }
            bufferedReader.close();
        }
    }

    protected double removeAndEvaluateBlock(int n, BlockInfo blockInfo, IDensityMeasure iDensityMeasure, boolean bl) throws Exception {
        this.runEvaluateJob(blockInfo);
        int[] nArray = blockInfo.blockCardinalities;
        long l = this.readEvaluateResult();
        System.out.println("Block: " + (n + 1));
        System.out.print("Volume: ");
        for (int i = 0; i < this.dimension; ++i) {
            System.out.print(nArray[i]);
            if (i >= this.dimension - 1) continue;
            System.out.print(" X ");
        }
        System.out.println();
        double d = iDensityMeasure.density(l, nArray);
        System.out.println("Density: " + d);
        System.out.println("Mass: " + l);
        if (bl) {
            return d;
        }
        this.runRemoveRJob();
        this.runAttValMassJob(this.currentRPath);
        this.readAttValMasses(this.attValMasses);
        this.massR = this.computeMass(this.attValMasses);
        return d;
    }

    private void runEvaluateJob(BlockInfo blockInfo) throws Exception {
        String string = blockInfo.returnFileInfo(this.getTempLocalFilePath());
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        fileSystem.copyFromLocalFile(true, true, new Path(string), new Path(this.distributedCachePath));
        if (fileSystem.exists(new Path(this.tempPath))) {
            fileSystem.delete(new Path(this.tempPath), true);
        }
        Job job = new Job(this.conf, "Evaluate");
        job.setJarByClass(EvaluateMR.class);
        job.setMapperClass(EvaluateMR.EvaluateMapper.class);
        job.setNumReduceTasks(1);
        job.setReducerClass(EvaluateMR.EvaluateReducer.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(this.originalPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(this.tempPath));
        DistributedCache.addCacheFile((URI)new Path(this.distributedCachePath).toUri(), (Configuration)job.getConfiguration());
        job.waitForCompletion(true);
    }

    private long readEvaluateResult() throws IOException {
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        String string = this.tempPath;
        FileStatus[] fileStatusArray = fileSystem.listStatus(new Path(string));
        long l = 0L;
        for (FileStatus fileStatus : fileStatusArray) {
            String string2;
            String string3 = fileStatus.getPath().getName();
            if (!string3.contains("part")) continue;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(new Path(string + "/" + string3))));
            while ((string2 = bufferedReader.readLine()) != null) {
                l += Long.valueOf(string2).longValue();
            }
            bufferedReader.close();
        }
        return l;
    }

    private void runRemoveRJob() throws Exception {
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        if (fileSystem.exists(new Path(this.tempPath))) {
            fileSystem.delete(new Path(this.tempPath), true);
        }
        Job job = new Job(this.conf, "RemoveR");
        job.setJarByClass(RemoveRMR.class);
        job.setMapperClass(RemoveRMR.RemoveRMapper.class);
        job.setNumReduceTasks(0);
        job.setReducerClass(RemoveRMR.RemoveRReducer.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(this.currentRPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(this.tempPath));
        DistributedCache.addCacheFile((URI)new Path(this.distributedCachePath).toUri(), (Configuration)job.getConfiguration());
        job.waitForCompletion(true);
        this.currentRPath = this.defaultCurrentRPath;
        if (fileSystem.exists(new Path(this.currentRPath))) {
            fileSystem.delete(new Path(this.currentRPath), true);
        }
        fileSystem.rename(new Path(this.tempPath), new Path(this.currentRPath));
    }

    private long computeMass(int[][] nArray) {
        long l = 0L;
        for (int i = 0; i < this.cardinalities[0]; ++i) {
            l += (long)nArray[0][i];
        }
        return l;
    }

    private String getOrderingFullPath(int n) {
        return this.logPath + File.separator + "ordering_info" + n;
    }

    private String getBlockInfoFullPath(int n) {
        return this.logPath + File.separator + "block_info" + n;
    }

    private void writeOutput(String string, List<BlockInfo> list) throws Exception {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getTempLocalFilePath();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
            boolean[][] blArrayArray = new boolean[this.dimension][];
            BlockInfo blockInfo = list.get(i);
            Set<Integer>[] setArray = blockInfo.getAttributeValues(this.dimension);
            for (int j = 0; j < this.dimension; ++j) {
                blArrayArray[j] = new boolean[this.cardinalities[j]];
                for (int n2 : setArray[j]) {
                    blArrayArray[j][n2] = true;
                    bufferedWriter.write(j + "," + n2);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
            FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
            fileSystem.copyFromLocalFile(true, true, new Path(string2), new Path(string + "/block_" + (i + 1) + ".attributes"));
            this.runComputeBOriJob(i, blockInfo);
        }
    }

    private void runComputeBOriJob(int n, BlockInfo blockInfo) throws Exception {
        String string = blockInfo.returnFileInfo(this.getTempLocalFilePath());
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        fileSystem.copyFromLocalFile(true, true, new Path(string), new Path(this.distributedCachePath));
        String string2 = this.outputPath + "/block_" + (n + 1) + ".tuples";
        Job job = new Job(this.conf, "ComputeBOri");
        job.setJarByClass(ComputeBOriMR.class);
        job.setMapperClass(ComputeBOriMR.ComputeBOriMapper.class);
        job.setNumReduceTasks(0);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(this.originalPath));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(string2));
        DistributedCache.addCacheFile((URI)new Path(this.distributedCachePath).toUri(), (Configuration)job.getConfiguration());
        job.waitForCompletion(true);
    }

    protected static enum TensorType {
        OriginalR,
        CurrentR;

    }
}

