/*
 * Decompiled with CFR 0.152.
 */
package dcube.hadoop;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class EvaluateMR {

    public static class EvaluateReducer
    extends Reducer<IntWritable, LongWritable, NullWritable, Text> {
        public void reduce(IntWritable intWritable, Iterable<LongWritable> iterable, Reducer.Context context) throws IOException, InterruptedException {
            long l = 0L;
            for (LongWritable longWritable : iterable) {
                l += longWritable.get();
            }
            context.write((Object)NullWritable.get(), (Object)new Text("" + l));
        }
    }

    public static class EvaluateMapper
    extends Mapper<Object, Text, IntWritable, LongWritable> {
        private int dimension = 0;
        private boolean[][] modeToAttValsIncluded;
        private long mass = 0L;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.dimension = context.getConfiguration().getInt("PARAM_DIMENSION", 0);
            this.modeToAttValsIncluded = new boolean[this.dimension][];
            for (int i = 0; i < this.dimension; ++i) {
                int n = context.getConfiguration().getInt("PARAM_CARDINALITY" + i, 0);
                this.modeToAttValsIncluded[i] = new boolean[n];
            }
            Path[] pathArray = DistributedCache.getLocalCacheFiles((Configuration)context.getConfiguration());
            if (pathArray != null && pathArray.length > 0) {
                for (Path path : pathArray) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(path.toString()), 0x800000));
                    try {
                        while (true) {
                            byte by = objectInputStream.readByte();
                            this.modeToAttValsIncluded[by][objectInputStream.readInt()] = true;
                        }
                    }
                    catch (EOFException eOFException) {
                        objectInputStream.close();
                    }
                }
            }
        }

        public void map(Object object, Text text, Mapper.Context context) throws IOException, InterruptedException {
            String[] stringArray = text.toString().split(",");
            boolean bl = true;
            for (int i = 0; i < this.dimension; ++i) {
                if (this.modeToAttValsIncluded[i][Integer.valueOf(stringArray[i])]) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.mass += (long)Integer.valueOf(stringArray[this.dimension]).intValue();
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            LongWritable longWritable = new LongWritable(this.mass);
            context.write((Object)new IntWritable(0), (Object)longWritable);
        }
    }
}

