/*
 * Decompiled with CFR 0.152.
 */
package dcube.hadoop;

import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class CardinalityMR {

    public static class CardinalityReducer
    extends Reducer<IntWritable, IntWritable, NullWritable, Text> {
        final Text text = new Text("");

        public void reduce(IntWritable intWritable, Iterable<IntWritable> iterable, Reducer.Context context) throws IOException, InterruptedException {
            int n = intWritable.get();
            int n2 = 0;
            for (IntWritable intWritable2 : iterable) {
                n2 = Math.max(intWritable2.get(), n2);
            }
            this.text.set(n + "," + (n2 + 1));
            context.write((Object)NullWritable.get(), (Object)this.text);
        }
    }

    public static class CardinalityMapper
    extends Mapper<Object, Text, IntWritable, IntWritable> {
        private int dimension = 0;
        private int[] maxModeAttValues;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.dimension = context.getConfiguration().getInt("PARAM_DIMENSION", 0);
            this.maxModeAttValues = new int[this.dimension];
        }

        public void map(Object object, Text text, Mapper.Context context) throws IOException, InterruptedException {
            String[] stringArray = text.toString().split(",");
            for (int i = 0; i < this.dimension; ++i) {
                int n = Integer.valueOf(stringArray[i]);
                this.maxModeAttValues[i] = Math.max(n, this.maxModeAttValues[i]);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            for (int i = 0; i < this.dimension; ++i) {
                context.write((Object)new IntWritable(i), (Object)new IntWritable(this.maxModeAttValues[i]));
            }
        }
    }
}

