/*
 * Decompiled with CFR 0.152.
 */
package dcube.hadoop;

import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class AttValMassMR {

    public static class AttValMassReducer
    extends Reducer<IntWritable, IntWritable, NullWritable, Text> {
        private Text text = new Text("");
        private int dimension = 0;
        private int maxCardinality = 0;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.dimension = context.getConfiguration().getInt("PARAM_DIMENSION", 0);
            for (int i = 0; i < this.dimension; ++i) {
                int n = context.getConfiguration().getInt("PARAM_CARDINALITY" + i, 0);
                this.maxCardinality = Math.max(this.maxCardinality, n);
            }
        }

        public void reduce(IntWritable intWritable, Iterable<IntWritable> iterable, Reducer.Context context) throws IOException, InterruptedException {
            int n = intWritable.get() / this.maxCardinality;
            int n2 = intWritable.get() - n * this.maxCardinality;
            long l = 0L;
            for (IntWritable intWritable2 : iterable) {
                l += (long)intWritable2.get();
            }
            this.text.set(n + "," + n2 + "," + l);
            context.write((Object)NullWritable.get(), (Object)this.text);
        }
    }

    public static class AttValMassMapper
    extends Mapper<Object, Text, IntWritable, IntWritable> {
        private int dimension = 0;
        private int[] cardinalities = null;
        private int[][] attValMasses = null;
        private int maxCardinality = 0;
        private IntWritable keyWritable = new IntWritable();
        private IntWritable valueWritable = new IntWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.dimension = context.getConfiguration().getInt("PARAM_DIMENSION", 0);
            this.cardinalities = new int[this.dimension];
            this.attValMasses = new int[this.dimension][];
            for (int i = 0; i < this.dimension; ++i) {
                int n;
                this.cardinalities[i] = n = context.getConfiguration().getInt("PARAM_CARDINALITY" + i, 0);
                this.maxCardinality = Math.max(this.maxCardinality, n);
                this.attValMasses[i] = new int[this.cardinalities[i]];
            }
        }

        public void map(Object object, Text text, Mapper.Context context) throws IOException, InterruptedException {
            String[] stringArray = text.toString().split(",");
            int n = Integer.valueOf(stringArray[this.dimension]);
            for (int i = 0; i < this.dimension; ++i) {
                int n2 = Integer.valueOf(stringArray[i]);
                int[] nArray = this.attValMasses[i];
                int n3 = n2;
                nArray[n3] = nArray[n3] + n;
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            for (int i = 0; i < this.dimension; ++i) {
                for (int j = 0; j < this.cardinalities[i]; ++j) {
                    if (this.attValMasses[i][j] <= 0) continue;
                    this.keyWritable.set(this.maxCardinality * i + j);
                    this.valueWritable.set(this.attValMasses[i][j]);
                    context.write((Object)this.keyWritable, (Object)this.valueWritable);
                }
            }
        }
    }
}

