/*
 * Decompiled with CFR 0.152.
 */
package dcube;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class Tensor {
    public int dimension;
    public int[] cardinalities;
    public int[][] attributes;
    public int[] measureValues;
    public long mass;
    public int bufferSize;
    public String attFilePath;
    public String valueFilePath;
    public int bufferUsage;
    public long diskUsage;

    public Tensor(int n, int[] nArray, long l, long l2, int n2, String string, String string2) {
        this.dimension = n;
        this.cardinalities = nArray;
        this.mass = l2;
        this.bufferSize = n2;
        this.attributes = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.attributes[i] = new int[n2];
        }
        this.measureValues = new int[n2];
        this.attFilePath = string;
        this.valueFilePath = string2;
        this.bufferUsage = 0;
        this.diskUsage = l;
    }

    public Tensor(int n, int[] nArray, int[][] nArray2, int[] nArray3, long l, long l2, int n2, int n3, String string, String string2) {
        this.dimension = n;
        this.cardinalities = nArray;
        this.mass = l2;
        this.bufferSize = n2;
        this.attributes = nArray2;
        this.measureValues = nArray3;
        this.attFilePath = string;
        this.valueFilePath = string2;
        this.bufferUsage = n3;
        this.diskUsage = l - (long)n3;
    }

    public Tensor(Tensor tensor, String string) throws IOException {
        this.dimension = tensor.dimension;
        this.cardinalities = tensor.cardinalities;
        this.mass = tensor.mass;
        this.bufferSize = tensor.bufferSize;
        this.attributes = tensor.attributes;
        this.measureValues = (int[])tensor.measureValues.clone();
        this.attFilePath = tensor.attFilePath;
        this.valueFilePath = string;
        if (tensor.diskUsage > 0L) {
            Files.copy(new File(tensor.valueFilePath).toPath(), new File(string).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.bufferUsage = tensor.bufferUsage;
        this.diskUsage = tensor.diskUsage;
    }

    public Tensor copy(String string) throws IOException {
        return new Tensor(this, string);
    }
}

