/*
 * Decompiled with CFR 0.152.
 */
package dcube;

import dcube.IDensityMeasure;

public class Suspiciousness
implements IDensityMeasure {
    private int dimension;
    private int[] cardinalities;
    private long massOfAll;
    private long massOfBlock;
    private double productOfCardinalitiesOfAll;
    private double productOfCardinalitiesOfBlock;

    @Override
    public double initialize(int n, int[] nArray, long l) {
        this.dimension = n;
        this.cardinalities = (int[])nArray.clone();
        this.massOfAll = l;
        this.massOfBlock = l;
        this.productOfCardinalitiesOfAll = 1.0;
        for (int i = 0; i < n; ++i) {
            this.productOfCardinalitiesOfAll *= (double)nArray[i];
        }
        this.productOfCardinalitiesOfBlock = this.productOfCardinalitiesOfAll;
        return this.density(this.massOfBlock, this.productOfCardinalitiesOfBlock);
    }

    @Override
    public double ifRemoved(int n, int n2) {
        return this.density(this.massOfBlock - (long)n2, this.productOfCardinalitiesOfBlock / (double)this.cardinalities[n] * (double)(this.cardinalities[n] - 1));
    }

    @Override
    public double ifRemoved(int n, int n2, long l) {
        return this.density(this.massOfBlock - l, this.productOfCardinalitiesOfBlock / (double)this.cardinalities[n] * (double)(this.cardinalities[n] - n2));
    }

    @Override
    public double remove(int n, int n2) {
        int n3 = n;
        this.cardinalities[n3] = this.cardinalities[n3] - 1;
        this.productOfCardinalitiesOfBlock = Suspiciousness.productOfCardinalities(this.cardinalities);
        this.massOfBlock -= (long)n2;
        return this.density(this.massOfBlock, this.productOfCardinalitiesOfBlock);
    }

    @Override
    public double density(long l, int[] nArray) {
        double d = 1.0;
        for (int i = 0; i < this.dimension; ++i) {
            d *= (double)nArray[i];
        }
        return this.density(l, d);
    }

    private double density(long l, double d) {
        if (d == 0.0 || l == 0L) {
            return -1.0;
        }
        return (double)l * (Math.log(((double)l + 0.0) / (double)this.massOfAll) - 1.0) + (double)this.massOfAll * d / this.productOfCardinalitiesOfAll - (double)l * Math.log(d / this.productOfCardinalitiesOfAll);
    }

    public static double productOfCardinalities(int[] nArray) {
        double d = 1.0;
        for (int i = 0; i < nArray.length; ++i) {
            d *= (double)nArray[i];
        }
        return d;
    }
}

