/*
 * Decompiled with CFR 0.152.
 */
package dcube;

import dcube.Arithmetic;
import dcube.BlockInfo;
import dcube.BlockIterInfo;
import dcube.DensityMeasure;
import dcube.Geometric;
import dcube.IDensityMeasure;
import dcube.Pair;
import dcube.Suspiciousness;
import dcube.Tensor;
import dcube.TensorMethods;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Proposed {
    public static final String originalAttName = "disk_att_original";
    public static final String originalValueName = "disk_value_original";
    public static final String currentValueName = "disk_value_current";
    public static final String blockAttName = "disk_att_block";
    public static final String blockValueName = "disk_value_block";
    public static final String tempAttName = "disk_att_temp";
    public static final String tempValueName = "disk_value_temp";
    private String outputPath = "";
    private Tensor Rori;
    private Tensor R;
    private Tensor B;
    private int[][] attValMasses;
    public static final int POLICY_MAX_CARNDILITY = 0;
    public static final int POLICY_MAX_DENSITY = 1;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 5) {
            Proposed.printError();
            System.exit(-1);
        }
        String string = stringArray[0];
        System.out.println("input_path: " + string);
        String string2 = stringArray[1];
        System.out.println("output_path: " + string2);
        File file = new File(string2);
        try {
            file.mkdir();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = Integer.valueOf(stringArray[2]);
        System.out.println("dimension: " + n);
        DensityMeasure densityMeasure = null;
        if (stringArray[3].compareToIgnoreCase("ARI") == 0) {
            densityMeasure = DensityMeasure.Arithmetic;
        } else if (stringArray[3].compareToIgnoreCase("GEO") == 0) {
            densityMeasure = DensityMeasure.Geometric;
        } else if (stringArray[3].compareToIgnoreCase("SUSP") == 0) {
            densityMeasure = DensityMeasure.Suspiciousness;
        } else {
            System.err.println("Unknown Density Measure");
            Proposed.printError();
            System.exit(-1);
        }
        System.out.println("density_measure: " + stringArray[3]);
        int n2 = 0;
        if (stringArray[4].compareToIgnoreCase("CARDINALITY") == 0) {
            n2 = 0;
        } else if (stringArray[4].compareToIgnoreCase("DENSITY") == 0) {
            n2 = 1;
        } else {
            System.err.println("Unknown Policy");
            Proposed.printError();
            System.exit(-1);
        }
        System.out.println("policy: " + stringArray[4]);
        double d = Double.valueOf(stringArray[5]);
        System.out.println("mass_threshold: " + d);
        if (d < 1.0) {
            System.err.println("Mass_threshold should be greater than or equal to one");
            Proposed.printError();
            System.exit(-1);
        }
        int n3 = Integer.valueOf(stringArray[6]);
        System.out.println("num_of_blocks: " + n3);
        System.out.println();
        System.out.println("computing proper buffer size");
        Pair<Long, int[]> pair = Proposed.probe(n, string, ",");
        long l = pair.getKey();
        int[] nArray = pair.getValue();
        int n4 = Proposed.getProperBufferSizeForInputTensor(n, l, nArray);
        System.out.println();
        System.out.println("storing the input tensor in the binary format...");
        Tensor tensor = TensorMethods.importSparseTensor(string, ",", n, nArray, n4, Proposed.getFullPath(string2, originalAttName), Proposed.getFullPath(string2, originalValueName));
        System.out.println();
        System.out.println("running the algorithm...");
        Proposed proposed = new Proposed(tensor, string2);
        System.out.println();
        proposed.run(n3, densityMeasure, n2, d);
    }

    private static void printError() {
        System.err.println("Usage: run_single.sh input_path output_path dimension density_measure policy mass_threshold num_of_blocks");
        System.err.println("Density_measure should be one of [ari, geo, susp]");
        System.err.println("Policy should be one of [density, cardinality]");
        System.err.println("Mass_threshold should be a number greater than or equal to one");
    }

    public Proposed(Tensor tensor, String string) throws IOException {
        this.Rori = tensor;
        this.outputPath = string;
    }

    private static String getFullPath(String string, String string2) {
        return string + File.separator + string2;
    }

    private String getFullPath(String string) {
        return this.outputPath + File.separator + string;
    }

    private String getOrderingFullPath(int n) {
        return this.outputPath + File.separator + "ordering_info" + n;
    }

    private String getBlockInfoFullPath(int n) {
        return this.outputPath + File.separator + "block_info" + n;
    }

    public static Pair<Long, int[]> probe(int n, String string, String string2) throws IOException {
        Object object;
        long l = 0L;
        int[] nArray = new int[n];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((object = bufferedReader.readLine()) != null) {
            String[] stringArray = ((String)object).split(string2);
            if (stringArray.length < n + 1) {
                System.out.println("Skipped Line: " + (String)object);
                continue;
            }
            ++l;
            for (int i = 0; i < n; ++i) {
                nArray[i] = Math.max(nArray[i], Integer.valueOf(stringArray[i]));
            }
        }
        bufferedReader.close();
        object = new int[n];
        for (int i = 0; i < n; ++i) {
            object[i] = nArray[i] + 1;
        }
        return new Pair<Long, Object>(l, object);
    }

    public static int getProperBufferSizeForInputTensor(int n, long l, int[] nArray) {
        long l2 = Runtime.getRuntime().maxMemory() * 7L / 10L;
        long l3 = 0L;
        for (int i = 0; i < n; ++i) {
            l3 = nArray[i];
        }
        System.gc();
        long l4 = l * (long)(2 * (n + 1) + 1) * 4L + 4L * l3 * 4L;
        long l5 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (l2 > l4 + l5 && l < Integer.MAX_VALUE) {
            return (int)l;
        }
        return 0;
    }

    private long getProperBufferSizeForBlocks(int n) {
        long l = Runtime.getRuntime().maxMemory() * 7L / 10L;
        System.gc();
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long l3 = l - l2;
        return Math.max(0L, l3 / 4L / (long)(n + 1));
    }

    private long getMass(TensorType tensorType) {
        if (tensorType == TensorType.OriginalR) {
            return this.Rori.mass;
        }
        return this.R.mass;
    }

    private int[][] getAttValMasses() {
        return this.attValMasses;
    }

    private int getDimension() {
        return this.Rori.dimension;
    }

    private int[] getCardinalities() {
        return this.Rori.cardinalities;
    }

    private void copyOriTesnor() throws IOException {
        this.R = this.Rori.copy(this.getFullPath(currentValueName));
    }

    private void copyBlock() {
        this.B = null;
        int n = (int)Math.min(Integer.MAX_VALUE, Math.min(this.getProperBufferSizeForBlocks(this.R.dimension), (long)this.R.bufferUsage + this.R.diskUsage));
        this.B = new Tensor(this.R.dimension, this.R.cardinalities, (long)this.R.bufferUsage + this.R.diskUsage, this.R.mass, n, this.getFullPath(blockAttName), this.getFullPath(blockValueName));
    }

    protected void initialize() throws IOException {
        this.attValMasses = null;
        this.attValMasses = TensorMethods.attributeValueMasses(this.R);
    }

    /*
     * Unable to fully structure code
     */
    protected void removeAndUpdateAttValMasses(int var1_1, boolean[] var2_2, int[][] var3_3, boolean var4_4) throws IOException {
        var5_5 = this.B.dimension;
        var6_6 = this.B.attributes;
        var7_7 = this.B.attributes[var1_1];
        var8_8 = this.B.measureValues;
        var9_9 = this.B.bufferSize;
        for (var10_10 = 0; var10_10 < var5_5; ++var10_10) {
            if (var10_10 == var1_1) continue;
            var11_11 = this.B.bufferUsage;
            var12_13 = var3_3[var10_10];
            var13_15 = var6_6[var10_10];
            block1: for (var14_17 = 0; var14_17 < var11_11; ++var14_17) {
                if (!var2_2[var7_7[var14_17]]) continue;
                v0 = var13_15[var14_17];
                var12_13[v0] = var12_13[v0] - var8_8[var14_17];
                --var11_11;
                while (var11_11 > var14_17) {
                    if (!var2_2[var7_7[var11_11]]) {
                        var13_15[var14_17] = var13_15[var11_11];
                        continue block1;
                    }
                    v1 = var13_15[var11_11];
                    var12_13[v1] = var12_13[v1] - var8_8[var11_11];
                    --var11_11;
                }
            }
        }
        var10_10 = this.B.bufferUsage;
        var11_12 = var3_3[var1_1];
        block3: for (var12_14 = 0; var12_14 < var10_10; ++var12_14) {
            if (!var2_2[var7_7[var12_14]]) continue;
            var11_12[var7_7[var12_14]] = 0;
            --var10_10;
            while (var10_10 > var12_14) {
                if (!var2_2[var7_7[var10_10]]) {
                    var7_7[var12_14] = var7_7[var10_10];
                    var8_8[var12_14] = var8_8[var10_10];
                    continue block3;
                }
                var11_12[var7_7[var10_10]] = 0;
                --var10_10;
            }
        }
        this.B.bufferUsage = var10_10;
        var12_14 = var10_10;
        if (this.B.diskUsage == 0L) {
            this.B.bufferUsage = var12_14;
            return;
        }
        if (var4_4) {
            var13_15 = this.R.measureValues;
            var14_18 = this.R.attributes[var1_1];
            var15_20 = this.R.bufferUsage;
            for (var16_22 = 0; var16_22 < var5_5; ++var16_22) {
                if (var16_22 == var1_1) continue;
                var17_24 = var12_14;
                var18_26 = var6_6[var16_22];
                var11_12 = var3_3[var16_22];
                var19_27 = this.R.attributes[var16_22];
                for (var20_28 = 0; var20_28 < var15_20; ++var20_28) {
                    if (var2_2[var14_18[var20_28]]) {
                        v2 = var19_27[var20_28];
                        var11_12[v2] = var11_12[v2] - var13_15[var20_28];
                        continue;
                    }
                    var18_26[var17_24++] = var19_27[var20_28];
                }
            }
            var11_12 = var3_3[var1_1];
            for (var16_22 = 0; var16_22 < var15_20; ++var16_22) {
                if (var2_2[var14_18[var16_22]]) {
                    v3 = var14_18[var16_22];
                    var11_12[v3] = var11_12[v3] - var13_15[var16_22];
                    continue;
                }
                var7_7[var12_14] = var14_18[var16_22];
                var8_8[var12_14++] = var13_15[var16_22];
            }
        }
        var13_16 = 0L;
        v4 = var15_21 = var4_4 != false ? this.R : this.B;
        if (var15_21.diskUsage > 0L) {
            var16_23 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getFullPath("disk_att_temp")), 0x800000));
            var17_25 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getFullPath("disk_value_temp")), 0x800000));
            var18_26 = new ObjectInputStream(new BufferedInputStream(new FileInputStream(var4_4 != false ? this.R.attFilePath : this.B.attFilePath), 0x800000));
            var19_27 = new ObjectInputStream(new BufferedInputStream(new FileInputStream(var4_4 != false ? this.R.valueFilePath : this.B.valueFilePath), 0x800000));
            var20_29 = new int[var5_5];
            block8: while (true) {
                if ((var21_30 = var19_27.readInt()) == -1) break;
                if (var21_30 == 0) {
                    var22_31 = 0;
                    while (true) {
                        if (var22_31 >= var5_5) continue block8;
                        var18_26.readInt();
                        ++var22_31;
                    }
                }
                for (var22_31 = 0; var22_31 < var5_5; ++var22_31) {
                    var20_29[var22_31] = var18_26.readInt();
                }
                if (var2_2[var20_29[var1_1]]) {
                    var22_31 = 0;
                    while (true) {
                        if (var22_31 >= var5_5) continue block8;
                        v5 = var3_3[var22_31];
                        v6 = var20_29[var22_31];
                        v5[v6] = v5[v6] - var21_30;
                        ++var22_31;
                    }
                }
                if (var12_14 < var9_9) {
                    for (var22_31 = 0; var22_31 < var5_5; ++var22_31) {
                        var6_6[var22_31][var12_14] = var20_29[var22_31];
                    }
                    var8_8[var12_14] = var21_30;
                    ++var12_14;
                    continue;
                }
                ++var13_16;
                var17_25.writeInt(var21_30);
                var22_31 = 0;
                while (true) {
                    if (var22_31 >= var5_5) ** break;
                    var16_23.writeInt(var20_29[var22_31]);
                    ++var22_31;
                }
                break;
            }
            var17_25.writeInt(-1);
            var18_26.close();
            var19_27.close();
            var16_23.close();
            var17_25.close();
        }
        this.B.bufferUsage = var12_14;
        this.B.diskUsage = var13_16;
        if (var13_16 > 0L) {
            new File(this.getFullPath("disk_att_block")).delete();
            new File(this.getFullPath("disk_value_block")).delete();
            new File(this.getFullPath("disk_att_temp")).renameTo(new File(this.getFullPath("disk_att_block")));
            new File(this.getFullPath("disk_value_temp")).renameTo(new File(this.getFullPath("disk_value_block")));
        }
    }

    protected double removeAndEvaluateBlock(int n, BlockInfo blockInfo, IDensityMeasure iDensityMeasure) throws IOException {
        int n2;
        int n3 = this.Rori.dimension;
        long l = 0L;
        int[] nArray = this.getCardinalities();
        for (int i = 0; i < n3; ++i) {
            this.attValMasses[i] = new int[nArray[i]];
        }
        boolean[][] blArray = blockInfo.getBitMask(n3, nArray);
        int[] nArray2 = blockInfo.blockCardinalities;
        int[][] nArray3 = this.R.attributes;
        int[] nArray4 = this.Rori.measureValues;
        int[] nArray5 = this.R.measureValues;
        int n4 = this.R.bufferUsage;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5;
            boolean bl = true;
            for (n5 = 0; n5 < n3; ++n5) {
                if (blArray[n5][nArray3[n5][n2]]) continue;
                bl = false;
                break;
            }
            if (bl) {
                l += (long)nArray4[n2];
            }
            if (!(bl & (n5 = nArray5[n2]) > 0)) continue;
            this.R.mass -= (long)n5;
            nArray5[n2] = 0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int[] nArray6 = nArray3[n2];
            int[] nArray7 = this.attValMasses[n2];
            for (int i = 0; i < n4; ++i) {
                int n6 = nArray5[i];
                int n7 = nArray6[i];
                nArray7[n7] = nArray7[n7] + n6;
            }
        }
        if (this.R.diskUsage > 0L) {
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.R.attFilePath), 0x800000));
            ObjectInputStream objectInputStream2 = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.Rori.valueFilePath), 0x800000));
            ObjectInputStream objectInputStream3 = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.R.valueFilePath), 0x800000));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getFullPath(tempValueName)), 0x800000));
            int[] nArray8 = new int[n3];
            while (true) {
                int n8;
                int n9;
                if ((n9 = objectInputStream2.readInt()) == -1) break;
                boolean bl = true;
                for (n8 = 0; n8 < n3; ++n8) {
                    nArray8[n8] = objectInputStream.readInt();
                    if (blArray[n8][nArray8[n8]]) continue;
                    bl = false;
                }
                if (bl) {
                    l += (long)n9;
                }
                if (bl & (n8 = objectInputStream3.readInt()) > 0) {
                    this.R.mass -= (long)n8;
                    objectOutputStream.writeInt(0);
                    continue;
                }
                if (n8 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        int[] nArray9 = this.attValMasses[i];
                        int n10 = nArray8[i];
                        nArray9[n10] = nArray9[n10] + n8;
                    }
                    objectOutputStream.writeInt(n8);
                    continue;
                }
                objectOutputStream.writeInt(n8);
            }
            objectOutputStream.writeInt(-1);
            objectInputStream.close();
            objectInputStream2.close();
            objectInputStream3.close();
            objectOutputStream.close();
        }
        System.out.println("Block: " + (n + 1));
        System.out.print("Volume: ");
        for (int i = 0; i < n3; ++i) {
            System.out.print(nArray2[i]);
            if (i >= n3 - 1) continue;
            System.out.print(" X ");
        }
        System.out.println();
        double d = iDensityMeasure.density(l, nArray2);
        System.out.println("Density: " + d);
        System.out.println("Mass: " + l);
        new File(this.R.valueFilePath).delete();
        new File(this.getFullPath(tempValueName)).renameTo(new File(this.R.valueFilePath));
        return d;
    }

    public void run(int n, DensityMeasure densityMeasure, int n2, double d) throws IOException {
        long l = System.currentTimeMillis();
        this.copyOriTesnor();
        this.initialize();
        IDensityMeasure iDensityMeasure = null;
        if (densityMeasure == DensityMeasure.Suspiciousness) {
            iDensityMeasure = new Suspiciousness();
        } else if (densityMeasure == DensityMeasure.Arithmetic) {
            iDensityMeasure = new Arithmetic();
        } else if (densityMeasure == DensityMeasure.Geometric) {
            iDensityMeasure = new Geometric();
        } else {
            System.out.println("Error: Unknown Density IMeasure");
        }
        iDensityMeasure.initialize(this.getDimension(), this.getCardinalities(), this.getMass(TensorType.OriginalR));
        LinkedList<BlockInfo> linkedList = new LinkedList<BlockInfo>();
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            BlockInfo blockInfo = this.findOneBlock(i, densityMeasure, n2, d);
            d2 = Math.max(d2, this.removeAndEvaluateBlock(i, blockInfo, iDensityMeasure));
            linkedList.add(blockInfo);
        }
        System.out.println("Running time: " + ((double)(System.currentTimeMillis() - l) + 0.0) / 1000.0 + " seconds");
        l = System.currentTimeMillis();
        System.out.println("Writing outputs...");
        Proposed.writeOutput(this.outputPath, this.Rori, linkedList);
        System.out.println("Outputs were written. " + ((double)(System.currentTimeMillis() - l) + 0.0) / 1000.0 + " seconds was taken.");
        System.out.println("Removing temporary files...");
        this.remove(n);
        System.out.println("Temporary files were removed.");
    }

    private void remove(int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.getFullPath(originalAttName));
        linkedList.add(this.getFullPath(originalValueName));
        linkedList.add(this.getFullPath(currentValueName));
        linkedList.add(this.getFullPath(blockAttName));
        linkedList.add(this.getFullPath(blockValueName));
        for (int i = 0; i < n; ++i) {
            linkedList.add(this.getBlockInfoFullPath(i));
            linkedList.add(this.getOrderingFullPath(i));
        }
        for (String string : linkedList) {
            if (!new File(string).exists()) continue;
            new File(string).delete();
        }
    }

    private BlockInfo findOneBlock(int n, DensityMeasure densityMeasure, int n2, double d) throws IOException {
        int n3;
        int n4 = this.getDimension();
        int[] nArray = this.getCardinalities();
        long l = this.getMass(TensorType.CurrentR);
        int[][] nArray2 = Proposed.createModeToAttVals(n4, nArray);
        int[][] nArray3 = this.getAttValMasses();
        int[] nArray4 = (int[])nArray.clone();
        int[] nArray5 = new int[n4];
        int n5 = Proposed.sumOfCarndinalities(n4, nArray);
        IDensityMeasure iDensityMeasure = null;
        if (densityMeasure == DensityMeasure.Suspiciousness) {
            iDensityMeasure = new Suspiciousness();
        } else if (densityMeasure == DensityMeasure.Arithmetic) {
            iDensityMeasure = new Arithmetic();
        } else if (densityMeasure == DensityMeasure.Geometric) {
            iDensityMeasure = new Geometric();
        } else {
            System.out.println("Error: Unknown Density IMeasure");
        }
        this.copyBlock();
        System.gc();
        BlockIterInfo blockIterInfo = new BlockIterInfo(nArray, BlockIterInfo.properBufferUsage(n5), this.getOrderingFullPath(n));
        int n6 = 0;
        double d2 = iDensityMeasure.initialize(this.getDimension(), this.getCardinalities(), this.getMass(TensorType.CurrentR));
        int n7 = 0;
        int n8 = 0;
        while (n7 < n5) {
            int n9;
            n3 = 0;
            double d3 = -1.7976931348623157E308;
            for (int i = 0; i < n4; ++i) {
                if (nArray4[i] <= 0) continue;
                if (n2 == 0) {
                    int n10 = nArray4[i];
                    if (!((double)n10 >= d3)) continue;
                    n3 = i;
                    d3 = n10;
                    continue;
                }
                if (n2 == 1) {
                    double d4 = (double)l * d / (double)nArray4[i];
                    int n11 = 0;
                    long l2 = 0L;
                    int[] nArray6 = nArray3[i];
                    int[] nArray7 = nArray2[i];
                    for (int j = nArray5[i]; j < nArray[i]; ++j) {
                        int n12 = nArray7[j];
                        if (!((double)nArray6[n12] <= d4)) continue;
                        ++n11;
                        l2 += (long)nArray6[n12];
                    }
                    if (n11 >= 1) {
                        double d5 = iDensityMeasure.ifRemoved(i, n11, l2);
                        if (!(d5 >= d3)) continue;
                        n3 = i;
                        d3 = d5;
                        continue;
                    }
                    System.out.println("Sanity Check!");
                    continue;
                }
                System.out.println("ERROR");
            }
            double d6 = (double)l * d / (double)nArray4[n3];
            int[] nArray8 = nArray3[n3];
            boolean[] blArray = new boolean[nArray[n3]];
            Proposed.sort(nArray2[n3], nArray3[n3], nArray5[n3], nArray[n3] - 1);
            int[] nArray9 = nArray2[n3];
            for (int i = nArray5[n3]; i < nArray[n3] && (double)nArray8[n9 = nArray9[i]] <= d6; ++i) {
                l -= (long)nArray8[n9];
                double d7 = iDensityMeasure.remove(n3, nArray8[n9]);
                if (d7 > d2) {
                    d2 = d7;
                    n6 = n7 + 1;
                }
                int n13 = n3;
                nArray5[n13] = nArray5[n13] + 1;
                int n14 = n3;
                nArray4[n14] = nArray4[n14] - 1;
                blockIterInfo.addIterInfo((byte)n3, n9);
                ++n7;
                blArray[n9] = true;
            }
            this.removeAndUpdateAttValMasses(n3, blArray, nArray3, n8 == 0);
            ++n8;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.attValMasses[n3] = new int[0];
        }
        return blockIterInfo.returnBlock(n6, this.getBlockInfoFullPath(n));
    }

    private static int sumOfCarndinalities(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i];
        }
        return n2;
    }

    private static int[][] createModeToAttVals(int n, int[] nArray) {
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = new int[nArray[i]];
            for (int j = 0; j < nArray[i]; ++j) {
                nArray2[j] = j;
            }
            nArrayArray[i] = nArray2;
        }
        return nArrayArray;
    }

    private static void sort(int[] nArray, int[] nArray2, int n, int n2) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (n >= n2) {
            return;
        }
        int n3 = n + (n2 - n) / 2;
        int n4 = nArray2[nArray[n3]];
        int n5 = n;
        int n6 = n2;
        while (n5 <= n6) {
            while (nArray2[nArray[n5]] < n4) {
                ++n5;
            }
            while (nArray2[nArray[n6]] > n4) {
                --n6;
            }
            if (n5 > n6) continue;
            int n7 = nArray[n5];
            nArray[n5] = nArray[n6];
            nArray[n6] = n7;
            ++n5;
            --n6;
        }
        if (n < n6) {
            Proposed.sort(nArray, nArray2, n, n6);
        }
        if (n2 > n5) {
            Proposed.sort(nArray, nArray2, n5, n2);
        }
    }

    private static void writeOutput(String string, Tensor tensor, List<BlockInfo> list) throws IOException {
        int n = list.size();
        int n2 = tensor.dimension;
        for (int i = 0; i < n; ++i) {
            int n3;
            Object object;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + File.separator + "block_" + (i + 1) + ".attributes"));
            boolean[][] blArrayArray = new boolean[tensor.dimension][];
            BlockInfo blockInfo = list.get(i);
            Set<Integer>[] setArray = blockInfo.getAttributeValues(n2);
            for (int j = 0; j < tensor.dimension; ++j) {
                blArrayArray[j] = new boolean[tensor.cardinalities[j]];
                object = setArray[j].iterator();
                while (object.hasNext()) {
                    n3 = object.next();
                    blArrayArray[j][n3] = true;
                    bufferedWriter.write(j + "," + n3);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
            bufferedWriter = new BufferedWriter(new FileWriter(string + File.separator + "block_" + (i + 1) + ".tuples"));
            int[][] nArray = tensor.attributes;
            object = tensor.measureValues;
            for (n3 = 0; n3 < tensor.bufferUsage; ++n3) {
                int n4;
                boolean bl = true;
                for (n4 = 0; n4 < n2; ++n4) {
                    if (blArrayArray[n4][nArray[n4][n3]]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                for (n4 = 0; n4 < n2; ++n4) {
                    bufferedWriter.write(nArray[n4][n3] + ",");
                }
                bufferedWriter.write("" + (int)object[n3]);
                bufferedWriter.newLine();
            }
            if (tensor.diskUsage > 0L) {
                int n5;
                ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(tensor.attFilePath), 0x800000));
                ObjectInputStream objectInputStream2 = new ObjectInputStream(new BufferedInputStream(new FileInputStream(tensor.valueFilePath), 0x800000));
                int[] nArray2 = new int[n2];
                while ((n5 = objectInputStream2.readInt()) != -1) {
                    int n6;
                    int n7;
                    for (n7 = 0; n7 < n2; ++n7) {
                        nArray2[n7] = objectInputStream.readInt();
                    }
                    n7 = 1;
                    for (n6 = 0; n6 < n2; ++n6) {
                        if (blArrayArray[n6][nArray2[n6]]) continue;
                        n7 = 0;
                        break;
                    }
                    if (n7 == 0) continue;
                    for (n6 = 0; n6 < n2; ++n6) {
                        bufferedWriter.write(nArray2[n6] + ",");
                    }
                    bufferedWriter.write("" + n5);
                    bufferedWriter.newLine();
                }
                objectInputStream.close();
                objectInputStream2.close();
            }
            bufferedWriter.close();
        }
    }

    protected static enum TensorType {
        OriginalR,
        CurrentR;

    }
}

