/*
 * Decompiled with CFR 0.152.
 */
package dcube;

import dcube.IDensityMeasure;
import dcube.Suspiciousness;

public class Geometric
implements IDensityMeasure {
    private int dimension;
    private int[] cardinalities;
    private long mass;
    private double productOfCardinalities;

    @Override
    public double initialize(int n, int[] nArray, long l) {
        this.dimension = n;
        this.cardinalities = (int[])nArray.clone();
        this.mass = l;
        this.productOfCardinalities = 1.0;
        for (int i = 0; i < n; ++i) {
            this.productOfCardinalities *= (double)nArray[i];
        }
        return this.density((double)l, this.productOfCardinalities);
    }

    @Override
    public double ifRemoved(int n, int n2) {
        return this.density((double)(this.mass - (long)n2), this.productOfCardinalities / (double)this.cardinalities[n] * (double)(this.cardinalities[n] - 1));
    }

    @Override
    public double ifRemoved(int n, int n2, long l) {
        return this.density((double)(this.mass - l), this.productOfCardinalities / (double)this.cardinalities[n] * (double)(this.cardinalities[n] - n2));
    }

    @Override
    public double remove(int n, int n2) {
        int n3 = n;
        this.cardinalities[n3] = this.cardinalities[n3] - 1;
        this.productOfCardinalities = Suspiciousness.productOfCardinalities(this.cardinalities);
        this.mass -= (long)n2;
        return this.density((double)this.mass, this.productOfCardinalities);
    }

    @Override
    public double density(long l, int[] nArray) {
        double d = 1.0;
        for (int i = 0; i < this.dimension; ++i) {
            d *= (double)nArray[i];
        }
        return this.density((double)l, d);
    }

    private double density(double d, double d2) {
        if (d2 == 0.0) {
            return -1.0;
        }
        return d / Math.pow(d2, 1.0 / (double)this.dimension);
    }
}

