/*
 * Decompiled with CFR 0.152.
 */
package dcube;

import dcube.BlockInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BlockIterInfo {
    private int dimension = 0;
    private byte[] modes = null;
    private int[] attributes = null;
    private boolean useBuffer = true;
    private int cardinalitySum = 0;
    private int curIndex = 0;
    private ObjectOutputStream out = null;
    private String orderingFilePath = null;

    public static boolean properBufferUsage(int n) {
        long l = Runtime.getRuntime().maxMemory() * 7L / 10L;
        System.gc();
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long l3 = l - l2;
        return l3 > 5L * (long)n;
    }

    public BlockIterInfo(int[] nArray, boolean bl, String string) throws IOException {
        this.useBuffer = bl;
        this.dimension = nArray.length;
        for (int i = 0; i < this.dimension; ++i) {
            this.cardinalitySum += nArray[i];
        }
        this.modes = new byte[this.cardinalitySum];
        this.attributes = new int[this.cardinalitySum];
        if (!bl) {
            this.orderingFilePath = string;
            this.out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(string), 0x800000));
        }
    }

    public void addIterInfo(byte by, int n) throws IOException {
        if (this.useBuffer) {
            this.modes[this.curIndex] = by;
            this.attributes[this.curIndex++] = n;
        } else {
            this.out.writeByte(by);
            this.out.writeInt(n);
        }
    }

    public BlockInfo returnBlock(int n, String string) throws IOException {
        int n2;
        if (this.out != null) {
            this.out.close();
        }
        if (this.useBuffer) {
            int[] nArray = new int[this.dimension];
            int n3 = this.cardinalitySum - n;
            byte[] byArray = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray[i] = this.modes[i + n];
                byte by = this.modes[i + n];
                nArray[by] = nArray[by] + 1;
            }
            int[] nArray2 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray2[i] = this.attributes[i + n];
            }
            return new BlockInfo(n3, nArray, byArray, nArray2);
        }
        int[] nArray = new int[this.dimension];
        int n4 = this.cardinalitySum - n;
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(string), 0x800000));
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.orderingFilePath), 0x800000));
        for (n2 = 0; n2 < n; ++n2) {
            objectInputStream.readByte();
            objectInputStream.readInt();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            byte by = objectInputStream.readByte();
            objectOutputStream.writeByte(by);
            byte by2 = by;
            nArray[by2] = nArray[by2] + 1;
            objectOutputStream.writeInt(objectInputStream.readInt());
        }
        objectInputStream.close();
        objectOutputStream.close();
        if (new File(this.orderingFilePath).exists()) {
            new File(this.orderingFilePath).delete();
        }
        return new BlockInfo(n4, nArray, string);
    }
}

