/*
 * Decompiled with CFR 0.152.
 */
package dcube;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;

public class BlockInfo {
    public int[] blockCardinalities;
    private byte[] modes = null;
    private int[] attVals = null;
    private int size = 0;
    public String diskFilePath = null;
    private boolean useBuffer = false;

    public BlockInfo(int n, int[] nArray, byte[] byArray, int[] nArray2) {
        this.size = n;
        this.useBuffer = true;
        this.modes = byArray;
        this.attVals = nArray2;
        this.blockCardinalities = nArray;
    }

    public BlockInfo(int n, int[] nArray, String string) {
        this.size = n;
        this.useBuffer = false;
        this.diskFilePath = string;
        this.blockCardinalities = nArray;
    }

    public Set<Integer>[] getAttributeValues(int n) throws IOException {
        int n2;
        Set[] setArray = new Set[n];
        for (n2 = 0; n2 < n; ++n2) {
            setArray[n2] = new HashSet();
        }
        if (this.useBuffer) {
            for (n2 = 0; n2 < this.size; ++n2) {
                byte by = this.modes[n2];
                setArray[by].add(this.attVals[n2]);
            }
        } else {
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.diskFilePath), 0x800000));
            for (int i = 0; i < this.size; ++i) {
                byte by = objectInputStream.readByte();
                setArray[by].add(objectInputStream.readInt());
            }
            objectInputStream.close();
        }
        return setArray;
    }

    public boolean[][] getBitMask(int n, int[] nArray) throws IOException {
        int n2;
        boolean[][] blArrayArray = new boolean[n][];
        for (n2 = 0; n2 < n; ++n2) {
            blArrayArray[n2] = new boolean[nArray[n2]];
        }
        if (this.useBuffer) {
            for (n2 = 0; n2 < this.size; ++n2) {
                byte by = this.modes[n2];
                blArrayArray[by][this.attVals[n2]] = true;
            }
        } else {
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.diskFilePath), 0x800000));
            for (int i = 0; i < this.size; ++i) {
                byte by = objectInputStream.readByte();
                blArrayArray[by][objectInputStream.readInt()] = true;
            }
            objectInputStream.close();
        }
        return blArrayArray;
    }

    public String returnFileInfo(String string) throws IOException {
        if (this.useBuffer) {
            String string2 = string;
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(string2), 0x800000));
            for (int i = 0; i < this.size; ++i) {
                objectOutputStream.writeByte(this.modes[i]);
                objectOutputStream.writeInt(this.attVals[i]);
            }
            objectOutputStream.close();
            return string2;
        }
        String string3 = string;
        Files.copy(new File(this.diskFilePath).toPath(), new File(string3).toPath(), StandardCopyOption.REPLACE_EXISTING);
        return string3;
    }

    public void clear() {
        if (!this.useBuffer && new File(this.diskFilePath).exists()) {
            new File(this.diskFilePath).delete();
        }
    }
}

