/*
 * Decompiled with CFR 0.152.
 */
package dcube;

import dcube.IDensityMeasure;

public class Arithmetic
implements IDensityMeasure {
    private int dimension;
    private long mass;
    private int sumOfCardinalities;

    @Override
    public double initialize(int n, int[] nArray, long l) {
        this.dimension = n;
        this.mass = l;
        this.sumOfCardinalities = 0;
        for (int i = 0; i < n; ++i) {
            this.sumOfCardinalities += nArray[i];
        }
        return this.density(l, this.sumOfCardinalities);
    }

    @Override
    public double ifRemoved(int n, int n2) {
        return this.density(this.mass - (long)n2, this.sumOfCardinalities - 1);
    }

    @Override
    public double ifRemoved(int n, int n2, long l) {
        return this.density(this.mass - l, this.sumOfCardinalities - n2);
    }

    @Override
    public double remove(int n, int n2) {
        this.mass -= (long)n2;
        --this.sumOfCardinalities;
        return this.density(this.mass, this.sumOfCardinalities);
    }

    @Override
    public double density(long l, int[] nArray) {
        int n = 0;
        for (int i = 0; i < this.dimension; ++i) {
            n += nArray[i];
        }
        return this.density(l, n);
    }

    private double density(long l, double d) {
        if (d == 0.0) {
            return -1.0;
        }
        return ((double)l + 0.0) / d * (double)this.dimension;
    }
}

