function [tangent_score intermediates] = tangent_movielens()

%
% You can change these variables below according to your environment.
%
c = 0.5;
% input
data_dir = '/afs/cs/usr/kensuke/data/ml-data-horror/';
data_file = 'u.data';
user_file = 'u.user';
movie_file = 'u.item';
matlab_dir = '/afs/cs/usr/kensuke/matlab/data/';
matlab_file = 'movielens_testdata';
id_pref = [944];
% output
ranking_data_file = ['/afs/cs/usr/kensuke/tmp/ranking_data.txt'];

try
    load([matlab_dir matlab_file], 'C', 'C_matrix', 'R', 'effective_ids', 'n_user');
catch
    disp('make matrix');
    [C C_matrix R effective_ids n_user] = make_matrix_for_movielens([data_dir data_file], c);
    save([matlab_dir matlab_file], 'C', 'C_matrix', 'R', 'effective_ids', 'n_user');
end

tmp_n_user = max(find(effective_ids <= n_user))

% Node (user)
[u_id u_age u_gender u_occupation u_zip] = textread(...
        [data_dir user_file], '%u %u %q %q %q', 'delimiter', '|');

for n = 1:length(id_pref)
    tmp_id_pref(n) = find(effective_ids == id_pref(n));
end
if length(tmp_id_pref) == 0
    error('no query');
end

u_node_name = {};
for n = 1:n_user
    tmp_node_name = sprintf('user%03d', u_id(n));
    u_node_name = [u_node_name; tmp_node_name];
end

% Node (movie)
[m_id m_title m_date m_v_date m_url...
 m_g_unknown m_g_action m_g_adv m_g_ani m_g_chi m_g_com m_g_cri m_g_doc...
 m_g_dra m_g_fan m_g_fil m_g_hor m_g_mus m_g_mys m_g_rom m_g_sci m_g_thr...
 m_g_war m_g_wes]= textread(...
        [data_dir movie_file],...
        '%u %q %q %q %q %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u',...
        'delimiter', '|');
n_movie = length(m_id)

m_node_name = {};
for n = 1:n_movie
    tmp_node_name = sprintf('movie%04d', m_id(n));
    m_node_name = [m_node_name; tmp_node_name];
end

[u_node m_node rating timestamp]= textread([data_dir data_file], '%u %u  %u %u');

if size(C,1) == 0 | size(C,2) == 0 | size(C_matrix,1) == 0 | size(C_matrix,2) == 0
    [C C_matrix_norm R] = make_matrix_for_movielens([data_dir data_file], c);
end

test_vec = zeros(size(C,1),1);
test_vec(tmp_id_pref) = 1;
trans = C*test_vec;
trans_id = find(trans>0);
target_nodes = setdiff([tmp_n_user+1:size(C,1)], trans_id);

neighbor = ones(size(C,1),1);
tmp_id_pref2 = tmp_id_pref;
[tangent_score intermediates] = tangent_undirected(...
        C, C_matrix, R, tmp_id_pref2);

pref_vec = zeros(size(C_matrix, 1), 1);
pref_vec(tmp_id_pref, 1) = 1;
[r_tmp realIter] = ppr_i2(C_matrix, c, pref_vec);
prev_pref = r_tmp;
second_score = tangent_score;

% just compare
total_weight = sum(C,2);
%total_weight = sum(C_matrix,2);
degree = sum(C>0,2);
ave_rating = total_weight./degree;
%ave_rating = var(C, 0, 1);

[sorted_prev_pref id_sorted_by_prev_pref]= sort(prev_pref, 1, 'descend');
disp('----- straight forward list (all) -----');
for n = 1:30
    tmp_rating = trans(id_sorted_by_prev_pref(n));
    if  tmp_rating > 0
        watched = ['X' int2str(tmp_rating) ' '];
    else
        watched = '';
    end
    if id_sorted_by_prev_pref(n) <= tmp_n_user
        tmp_id = effective_ids(id_sorted_by_prev_pref(n));
        disp([watched u_node_name{tmp_id} ':' int2str(u_age(tmp_id)) ':' u_gender{tmp_id} ':' u_occupation{tmp_id} ' --- ' num2str(sorted_prev_pref(n)) ' D(' int2str(degree(id_sorted_by_prev_pref(n))) ')']);
    else
        tmp_id = effective_ids(id_sorted_by_prev_pref(n))-n_user;
        disp([watched m_node_name{tmp_id} ':' m_title{tmp_id} ' --- ' num2str(sorted_prev_pref(n)) ' D(' int2str(degree(id_sorted_by_prev_pref(n))) ')']);
    end
end

%target_nodes = [tmp_n_user+1:size(C,1)];

[tmp tmp2] = sort(prev_pref(target_nodes), 1, 'descend');
target_nodes_sorted_by_prev_pref = target_nodes(tmp2);

[tmp tmp2] = sort(second_score(target_nodes), 1);
target_nodes_sorted_by_second_score = target_nodes(tmp2(end:-1:1));

tmp = find(second_score(target_nodes) > 0);
corr(prev_pref, second_score)
corr(prev_pref(target_nodes), second_score(target_nodes))
corr(prev_pref(target_nodes(tmp)), second_score(target_nodes(tmp)))
corr(log(prev_pref(target_nodes(tmp))), log(second_score(target_nodes(tmp))))

disp(' ');
disp(['----- straight forward list (out of ' int2str(length(target_nodes_sorted_by_prev_pref)) ' unwatched video) -----']);
for n = 1:min(30,length(target_nodes_sorted_by_prev_pref))
    tmp_id = effective_ids(target_nodes_sorted_by_prev_pref(n))-n_user;
    disp(['Top' int2str(n) '|' m_node_name{tmp_id} ':' m_title{tmp_id} ' --- ' num2str(prev_pref(target_nodes_sorted_by_prev_pref(n))) '/New Score Top' int2str(find(target_nodes_sorted_by_second_score == target_nodes_sorted_by_prev_pref(n))) ' AveRating:' num2str(ave_rating(target_nodes_sorted_by_prev_pref(n))) ' D(' int2str(degree(target_nodes_sorted_by_prev_pref(n))) ')']);
end

disp(' ');
disp(['----- new score list (out of ' int2str(length(target_nodes_sorted_by_second_score)) ' unwatched video) -----']);
for n = 1:min(30,length(target_nodes_sorted_by_second_score))
    tmp_id = effective_ids(target_nodes_sorted_by_second_score(n))-n_user;
    tmp_id2 = find(m_id == effective_ids(tmp_id_pref2(neighbor(target_nodes_sorted_by_second_score(n))))-n_user);
    disp(['Top' int2str(n) '|' m_node_name{tmp_id} ':' m_title{tmp_id} ' --- ' num2str(second_score(target_nodes_sorted_by_second_score(n))) '/Prev Pref Top' int2str(find(target_nodes_sorted_by_prev_pref == target_nodes_sorted_by_second_score(n))) ' AveRating:' num2str(ave_rating(target_nodes_sorted_by_second_score(n))) ' D(' int2str(degree(target_nodes_sorted_by_second_score(n))) ') neighbor(' m_title{tmp_id2} ')']);
end

tmp = find(second_score(target_nodes) > 0);
corr(total_weight, second_score)
corr(total_weight(target_nodes), second_score(target_nodes))
corr(total_weight(target_nodes(tmp)), second_score(target_nodes(tmp)))
corr(log(total_weight(target_nodes(tmp))), log(second_score(target_nodes(tmp))))

%tmp = find(prev_pref(target_nodes) > 0);
%corr(total_weight, prev_pref)
%corr(total_weight(target_nodes), prev_pref(target_nodes))
%corr(total_weight(target_nodes(tmp)), prev_pref(target_nodes(tmp)))
%corr(log(total_weight(target_nodes(tmp))), log(prev_pref(target_nodes(tmp))))

[tmp tmp2] = sort(total_weight(target_nodes), 1);
target_nodes_sorted_by_weight = target_nodes(tmp2(end:-1:1));
disp(' ');
disp(['----- total weight list (out of ' int2str(length(target_nodes_sorted_by_weight)) ' unwatched video) -----']);
for n = 1:min(30,length(target_nodes_sorted_by_weight))
    tmp_id = effective_ids(target_nodes_sorted_by_weight(n))-n_user;
    disp(['Top' int2str(n) '|' m_node_name{tmp_id} ':' m_title{tmp_id} ' --- ' num2str(total_weight(target_nodes_sorted_by_weight(n))) '/Prev Pref Top' int2str(find(target_nodes_sorted_by_prev_pref == target_nodes_sorted_by_weight(n))) '/New Score Top' int2str(find(target_nodes_sorted_by_second_score == target_nodes_sorted_by_weight(n))) ' AveRating:' num2str(ave_rating(target_nodes_sorted_by_weight(n))) ' D(' int2str(degree(target_nodes_sorted_by_weight(n))) ')']);
end

[tmp tmp2] = sort(degree(target_nodes), 1);
target_nodes_sorted_by_degree = target_nodes(tmp2(end:-1:1));
disp(' ');
disp(['----- degree list (out of ' int2str(length(target_nodes_sorted_by_degree)) ' unwatched video) -----']);
for n = 1:min(30,length(target_nodes_sorted_by_degree))
    tmp_id = effective_ids(target_nodes_sorted_by_degree(n))-n_user;
    disp(['Top' int2str(n) '|' m_node_name{tmp_id} ':' m_title{tmp_id} ' --- ' num2str(degree(target_nodes_sorted_by_degree(n))) '/Prev Pref Top' int2str(find(target_nodes_sorted_by_prev_pref == target_nodes_sorted_by_degree(n))) '/New Score Top' int2str(find(target_nodes_sorted_by_second_score == target_nodes_sorted_by_degree(n))) ' AveRating:' num2str(ave_rating(target_nodes_sorted_by_degree(n))) ' D(' int2str(degree(target_nodes_sorted_by_degree(n))) ')']);
end

fid_ranking_data = fopen(ranking_data_file, 'w');
for n = 1:length(target_nodes)
    tmp_id = effective_ids(target_nodes(n))-n_user;
    fprintf(fid_ranking_data, '%s %e %e %d %d %e\n',...
            ['"' m_title{tmp_id} '"'],...
            prev_pref(target_nodes(n)),...
            second_score(target_nodes(n)),...
            total_weight(target_nodes(n)),...
            degree(target_nodes(n)),...
            ave_rating(target_nodes(n)));
end
fclose(fid_ranking_data);

figure;
loglog(prev_pref(target_nodes), second_score(target_nodes), 'b.');
%plot(log(prev_pref(target_nodes)), (second_score(target_nodes)), 'b.');
%plot(prev_pref(target_nodes), second_score(target_nodes), 'b.');
hold off;
xlabel('relevance score');
ylabel('TANGENT score');
title('relevance score v.s. TANGENT score');
grid off;

figure;
loglog(prev_pref(target_nodes), total_weight(target_nodes), 'b.');
%plot(prev_pref(target_nodes), total_weight(target_nodes), 'b.');
hold off;
xlabel('relevance score');
ylabel('total weight');
title('relevance score v.s. total weight');
grid off;

figure;
loglog(second_score(target_nodes), total_weight(target_nodes), 'b.');
%loglog(second_score, total_weight, 'b.');
%plot(second_score(target_nodes), total_weight(target_nodes), 'b.');
hold off;
xlabel('TANGENT score');
%xlabel('bridging score');
ylabel('total weight');
title('TANGENT score v.s. total weight');
%title('bridging score v.s. total weight');
grid off;

figure;
loglog(prev_pref(target_nodes), degree(target_nodes), 'b.');
%plot(prev_pref(target_nodes), degree(target_nodes), 'b.');
hold off;
xlabel('relevance score');
ylabel('degree');
title('relevance score v.s. degree');
grid off;

figure;
loglog(second_score(target_nodes), degree(target_nodes), 'b.');
%plot(second_score(target_nodes), degree(target_nodes), 'b.');
hold off;
xlabel('TANGENT score');
ylabel('degree');
title('TANGENT score v.s. degree');
grid off;

figure;
loglog(total_weight(target_nodes), degree(target_nodes), 'b.');
%plot(total_weight(target_nodes), degree(target_nodes), 'b.');
hold off;
xlabel('total weight');
ylabel('degree');
title('total weight v.s. degree');
grid off;

user_degree = degree(1:tmp_n_user);
[tmp tmp2] = sort(user_degree, 1);
user_degree_sorted_by_degree = tmp(end:-1:1);
figure;
loglog([1:tmp_n_user], user_degree_sorted_by_degree, 'b.');
%plot(log([1:tmp_n_user]), log(user_degree_sorted_by_degree), 'b.');
%plot([1:tmp_n_user], user_degree_sorted_by_degree, 'b.');
xlabel('rank');
ylabel('degree');
title('degree of users');
grid off;

target_degree = degree(target_nodes);
[tmp tmp2] = sort(target_degree, 1);
target_degree_sorted_by_degree = tmp(end:-1:1);
figure;
loglog([1:length(target_nodes)], target_degree_sorted_by_degree, 'b.');
%plot(log([1:length(target_nodes)]), log(target_degree_sorted_by_degree), 'b.');
%plot([1:length(target_nodes)], target_degree_sorted_by_degree, 'b.');
xlabel('rank');
ylabel('degree');
title('degree of target movies');
grid off;

