function [C C_matrix_norm R effective_ids n_user] = make_matrix_for_movielens(data_file,c)

result = [];

[user_id item_id rating timestamp]= textread(data_file, '%u %u  %u %u');
n_user = max(user_id)

positive_rating = find(rating > 3);
C = sparse([user_id(positive_rating); item_id(positive_rating) + n_user], [item_id(positive_rating) + n_user; user_id(positive_rating)], [4.^(rating(positive_rating)-4); 4.^(rating(positive_rating)-4)]);
size(C)
effective_ids = find(sum(C,1) > 0);
C = C(effective_ids, effective_ids);
if 0
degree = sum(C>0,2);
C = C ./ ((degree * degree').^0.5);
end
size(C)

%C = sparse([user_id; item_id + n_user], [item_id + n_user; user_id], [rating; rating]);
%C = sparse([user_id; item_id + n_user], [item_id + n_user; user_id], [rating.^2; rating.^2]);

C_matrix_norm = [];

if 0
    % normalize matrix by column
    for n = 1:size(C,2)
        C_matrix_norm = [C_matrix_norm C(:,n)/sum(C(:,n))]; 
    %    C_matrix_norm = [C_matrix_norm C(:,n)/(sum(C(:,n))^1.1)]; 
    %    C_matrix_norm = [C_matrix_norm C(:,n)/(sum(C(:,n))^2)]; 
    end
else
    % normalize matrix by normalized graph Laplacian
    C_sum = sum(C, 2);
    D_half = sparse(size(C,1), size(C,2) ,0);
    for n = 1:size(C,1)
        D_half(n,n) = 1/sqrt(C_sum(n));
    end
    size(D_half);
    C_matrix_norm = D_half*C*D_half;
end
disp('normalize matrix -- done');

R = [];
if 1
for n = 1:size(C_matrix_norm, 1)
    % setup reset vector
    pref_vec = zeros(size(C_matrix_norm, 1), 1);
    pref_vec(n, 1) = 1;

    % do rwr
    [r_tmp realIter] = ppr_i2(C_matrix_norm, c, pref_vec);

    r_tmp = r_tmp/sum(r_tmp);
    R = [R r_tmp];
end
disp('RWR all done');
end
