function TrClusters=remove_duplicate_clusters(TrClusters)
ncl=length(TrClusters);
bin=double(cat(1,TrClusters(:).label));

Inter=bin*bin';
Union=sum(bin,2)*ones(1,ncl)+ones(ncl,1)*sum(bin,2)'-Inter;

IoU=Inter./Union;
thresh=0.95;
on=ones(ncl,1);
select=zeros(ncl,1);
i=1;
while i<=ncl
   if on(i)==0
       i=i+1; 
       continue;
   end
    select(i)=1;
    on(IoU(i,:)>thresh)=0;
    i=i+1;
end

TrClusters=TrClusters(select==1);