function h = plot_trajectory_labels_boxes(tr, tr_labels, Boxes, imnames, ...
    cols,put_text, figno, markersize)
h=[];

if iscell(Boxes)
    Boxes = cat(2,Boxes{:});
end

[XYT,tr_id]=quick_tr(tr);
if ~exist('markersize', 'var')
    markersize = 4;
end
%ts=1:t_step:length(imnames);
nf = length(imnames);
nr = ceil(sqrt(nf));
nc = ceil(nf/nr);


cl_id = setdiff(unique(union(tr_labels(tr_labels>=0),Boxes(6,:))),0);
if ~exist('cols', 'var')| isempty(cols)
    if ~isempty(find(cl_id==0))
        cols=jet(length(cl_id)-1);
        cols = cols(randperm(length(cl_id)-1),:);
        cols=[[1 1 1];cols];
    else
        cols = jet(length(cl_id)+1);
        cols = cols(randperm(length(cl_id)),:);
    end
end



if figno>0
    h = figure(figno);clf;
elseif figno==0
    h = figure('visible', 'off');
end

cnt = 0;

for i = 1:length(imnames)
    t=imnames(i).t;
    cnt = cnt+1;
    if ~isempty(imnames)
        img = imread(imnames(i).name);
        
        subplot2(nr,nc, cnt);
        imshow(img);
        hold on;
    end
    [X,Y,tr_id_c]=get_current_xytrid(XYT,tr_id,t);
    tr_pts=[X Y];
    tr_labels_c = tr_labels(tr_id_c);
    
    

    if isempty(Boxes)
        boxes=[];
    else
        boxes = Boxes(:,Boxes(5,:)==t);
    end
    
    id_inds = cell(length(cl_id),1);
    for n = 1:length(cl_id)
        id_inds{n} = tr_labels_c==cl_id(n);
        if sum(id_inds{n})==0
            continue;
        end
        
        plot(tr_pts(id_inds{n},1), tr_pts(id_inds{n},2), 'o', 'markersize',markersize, 'color', cols(n,:));
    end
    
    if put_text > 0
        for n = 1:length(cl_id)
            mc = mean(tr_pts(id_inds{n},:),1);
            text(mc(1),mc(2),num2str(cl_id(n)),'BackgroundColor',cols(n,:));
        end
    end
    
     if ~isempty(boxes)
        interp=[boxes(7,:)==0];
        boxes=[boxes(:,interp==0) boxes(:,interp==1)];
        for n=1:size(boxes,2)
            boxs = boxes(:, n);
            if ~isempty(boxs)
                interpc=boxs(7)==0;
                box=boxs(1:4);
                if (~isempty(box)) & (~isempty(find(cl_id==boxs(6))))
                    if interpc
                        rectangle('position', [box(1), box(2), box(3)-box(1)+1, box(4)-box(2)+1],...
                            'LineStyle', '--','edgecolor', ...
                            cols(find(cl_id==boxs(6)),:) , 'linewidth', 2);
                    else
                        rectangle('position', [box(1), box(2), box(3)-box(1)+1, box(4)-box(2)+1],...
                            'edgecolor', cols(find(cl_id==boxs(6)),:), 'linewidth', 4);
%                   rectangle('position', [box(1), box(2), box(3)-box(1)+1, box(4)-box(2)+1],...
%                             'edgecolor', [0 0 0], 'linewidth', 4);
                     end
                    
                     text(double(box(1)), double(box(2)),num2str(boxs(6)),...
                         'BackgroundColor',cols(find(cl_id==boxs(6)),:));
%     
                end
            end
        end
     end
    
    title(num2str(t))
end

set(gcf,'name','Trajectory Cluster Label');
