function h = plot_trajectory_clusters_boxes(TrClusters, Boxes, imnames, ...
    cols,put_text, figno, markersize)
h=[];
if ~isfield(TrClusters,'id')
    cl_id=1:length(TrClusters);
else
cl_id=cat(2,TrClusters(:).id);
end
if iscell(Boxes)
    Boxes = cat(2,Boxes{:});
end


if ~exist('markersize', 'var')
    markersize = 4;
end


[XYT,cluster_id]=quick_trcluster(TrClusters);

nf = length(imnames);
nr = ceil(sqrt(nf));
nc = ceil(nf/nr);

nlabels=length(TrClusters);

if ~exist('cols', 'var')| isempty(cols)
    
        cols = jet(nlabels);
        cols = cols(randperm(nlabels),:);
   % end
end



if figno>0
    h = figure(figno);clf;
elseif figno==0
    h = figure('visible', 'off');
end

cnt = 0;

for i = 1:length(imnames)
    t=imnames(i).t;
    cnt = cnt+1;
    if ~isempty(imnames)
        img = imread(imnames(i).name);
        if length(imnames)>1
        subplot2(nr,nc, cnt);
        end
        imshow(img);
        hold on;
    end
    
    [X,Y,cluster_id_c]=get_current_xytrid(XYT,cluster_id,t);
    
    tr_pts=[X Y];
   
    
    

    if isempty(Boxes)
        boxes=[];
    else
        boxes = Boxes(:,Boxes(5,:)==t);
    end
    
    id_inds = cell(nlabels,1);
    for n = cl_id
        id_inds{n} = cluster_id_c==n;
        if sum(id_inds{n})==0
            continue;
        end
        
        plot(tr_pts(id_inds{n},1), tr_pts(id_inds{n},2), 'o', 'markersize',markersize, 'color', cols(n,:),'linewidth',2);
    end
    
    if put_text > 0
        for n = cl_id
            mc = mean(tr_pts(id_inds{n},:),1);
            text(mc(1),mc(2),num2str(n),'BackgroundColor',cols(cl_id==n,:));
        end
    end
    
     if ~isempty(boxes)
        interp=[boxes(7,:)==0];
        boxes=[boxes(:,interp==0) boxes(:,interp==1)];
        for n=1:size(boxes,2)
            boxs = boxes(:, n);
            if ~isempty(boxs)
                interpc=boxs(7)==0;
                box=boxs(1:4);
                if (~isempty(box)) & ...
                    (~isempty(find(cl_id==boxs(6))))
                    if interpc
                        rectangle('position', [box(1), box(2), box(3)-box(1)+1, box(4)-box(2)+1],...
                            'LineStyle', '--','edgecolor', ...
                            cols(cl_id==boxs(6),:) , 'linewidth', 4);
                        
                    else
                        
                        rectangle('position', [box(1), box(2), box(3)-box(1)+1, box(4)-box(2)+1],...
                            'edgecolor', cols(cl_id==boxs(6),:), 'linewidth', 4);
                    end
                    

                    text(double(box(1)), double(box(2)),num2str(double(boxs(6))),'BackgroundColor',cols(cl_id==boxs(6),:));
%     text(round(box(1)), round(box(2)),num2str(boxs(6)))
                end
            end
        end
     end
    
    title(num2str(t))
end

set(gcf,'name','Trajectory Cluster Label');
