function [rr,On]=IoUboxes_mean_common(b1,b2)
%xmin ymin xmax ymax

n=size(b1,2);
r=zeros(1,size(b1,2));
R=zeros(1,length(b1(5,:)));
on=ones(1,length(b1(5,:)));
for i=1:n
    t=b1(5,i);
    inds=find(b2(5,:)==t);
    for j=1:length(inds)
        r(j)=IoUbox(b1(1:4,i),b2(1:4,inds(j)));
    end
    if length(inds)==0
        R(i)=0;
        on(i)=0;
    else
    R(i)=max(r);
    end
end
rr=mean(R(on==1));
On=nnz(on);


    function r=IoUbox(b1,b2)
        I=[max(b1(1),b2(1)) max(b1(2),b2(2)) min(b1(3),b2(3)) min(b1(4),b2(4))];
        
        U=area(b1)+area(b2) -area(I);
        r=max(area(I)/U,area(b2)/U);
        
        function a=area(b)
            a=(b(3)-b(1)+1)*(b(4)-b(2)+1);
            
        end
    end
end