function r=IoUboxes(b1,b2)
%xmin ymin xmax ymax


r=zeros(1,size(b1,2));
for i=1:size(b1,2)
    r(i)=IoUbox(b1(:,i),b2(:,i));
end


    function r=IoUbox(b1,b2)
        I=[max(b1(1),b2(1)) max(b1(2),b2(2)) min(b1(3),b2(3)) min(b1(4),b2(4))];
        
        U=area(b1)+area(b2) -area(I);
        r=area(I)/U;
        
        function a=area(b)
            a=(b(3)-b(1))*(b(4)-b(2));
            
        end
    end
end