function poselet_detector=configure_poselet()
global config;
config_poselet;
faster_detection = false;  % Set this to false to run slower but higher quality
%interactive_visualization = true; % Enable browsing the results
enable_bigq = true; % enables context poselets
if faster_detection
    disp('Using parameters optimized for speed over accuracy.');
    config.DETECTION_IMG_MIN_NUM_PIX = 500^2;  % if the number of pixels in a detection image is < DETECTION_IMG_SIDE^2, scales up the image to meet that threshold
    config.DETECTION_IMG_MAX_NUM_PIX = 750^2;
    config.PYRAMID_SCALE_RATIO = 2;
end
% Loads the SVMs for each poselet and the Hough voting params
clear output poselet_patches fg_masks;
poselet_detector=load('model_person.mat'); % model
if exist('output','var')
    model=output; clear output;
end
if ~enable_bigq
    model =rmfield(model,'bigq_weights');
    model =rmfield(model,'bigq_logit_coef');
    disp('Context is disabled.');
end
clear masks;
for i=1:length(poselet_detector.fg_masks)
    poselet_detector.fg_masks_centered{i} = get_center_mask(poselet_detector.fg_masks{i});
end