function boxes = propagate_boxes_stict(tl_boxes, tr,TS)
if length(tr)<5
    boxes=tl_boxes;
    return;
end
if isempty(tr)
    boxes=tl_boxes;
    return;
end
if isempty(tl_boxes)
    boxes=[];
    return;
end
t_given=tl_boxes(5,:);
XYT=cat(2,tr(:).XYTPos);
T=XYT(3,:);
if isempty(TS)
    TS=min(min(T),min(tl_boxes(5,:))):max(max(T),max(tl_boxes(5,:)));
end
bins=hist(T,min(T):max(T));
maxbin=max(bins);
min_tr_sz = max(5,max(floor(maxbin/5),10));
[XYT, tr_ids1] = quick_tr(tr, 0);
tmin = min(min(XYT(3,:)),min(TS));
tmax = max(max(XYT(3,:)),max(TS));

boxes = zeros(size(tl_boxes,1),tmax-tmin+1);

% first put in place the given boxes
idx = tl_boxes(5,:)-tmin+1;
boxes(:,idx) = tl_boxes;
t_st = find(boxes(5,:)>0, 1, 'first');
for t = [t_st:size(boxes,2), t_st-1:-1:1]
    %     box = tl_boxes(:,tl_boxes(5,:)==t+t_st-1);
    if boxes(5,t)>0
        continue;
    end
    t_prev = find(boxes(5, 1:t-1)~=0, 1, 'last');
    t_next = find(boxes(5, t+1:end)~=0, 1, 'first');
    if isempty(t_prev)
        box_prev = [0 0 0 0]';
        box_next = boxes(1:4,t+t_next);
    elseif isempty(t_next)
        box_prev = boxes(1:4,t_prev);
        box_next = [0 0 0 0]';
    else
        box_prev = boxes(1:4,t_prev);
        box_next = boxes(1:4,t+t_next);
    end
    
    % anchor position and scale
    t_cur = tmin+t-1;
    idx_cur = XYT(3,:)==t_cur;
    xy_cur = XYT(1:2, idx_cur);
    ids_cur = tr_ids1(idx_cur);
    if isempty(t_prev)
        t_ref = tmin+t+t_next-1;
        idx_ref = XYT(3,:)==t_ref;
        xy_ref = XYT(1:2, idx_ref);
        ids_ref = tr_ids1(idx_ref);
    else
        t_ref = tmin+t_prev-1;
        idx_ref = XYT(3,:)==t_ref;
        xy_ref = XYT(1:2, idx_ref);
        ids_ref = tr_ids1(idx_ref);
    end
    [~, ii,jj] = intersect(ids_cur, ids_ref);
    %     if length(ii) < min_tr_sz
    %         continue;
    %     end
    xy_cur = xy_cur(:,ii);
    xy_ref = xy_ref(:,jj);
    %         shift = mean(xy_cur-xy_ref, 2);
    
    if isempty(t_prev)
        box_ref = box_next;
    else
        box_ref = box_prev;
    end
    
    %     if t+tmin-1==42
    %         iiii=0;
    %     end
    box_cur = propagate_box(xy_ref, box_ref, xy_cur);
    % check area change
    a_c = get_area(box_cur);
    a_r = get_area(box_ref);
    if a_c/(a_r+eps) > 2.5 || a_r/(a_c+eps) > 2.5||a_c<=0||box_cur(3)<0||box_cur(4)<0
        continue;
    end
    in_idx = xy_cur(1,:)>box_cur(1) &  xy_cur(1,:)<box_cur(3) &  xy_cur(2,:)>box_cur(2) &  xy_cur(2,:)<box_cur(4);
    if sum(in_idx)/length(in_idx)<0.9
        %if sum(in_idx)>min_tr_sz% && length(in_idx)-sum(in_idx) < min_tr_sz
        % try again
        xy_cur2 = xy_cur(:,in_idx);
        xy_ref2 = xy_ref(:,in_idx);
        box_cur = propagate_box(xy_ref2, box_ref, xy_cur2);
        a_c = get_area(box_cur);
        a_r = get_area(box_ref);
        if a_c/(a_r+eps) > 2.5 || a_r/(a_c+eps) > 2.5||a_c<=0||box_cur(3)<0||box_cur(4)<0
            continue;
        end
        
        %             in_idx2 = xy_cur2(1,:)>box_cur(1) &  xy_cur2(1,:)<box_cur(3) &  xy_cur2(2,:)>box_cur(2) &  xy_cur2(2,:)<box_cur(4);
        %             if sum(in_idx2)/length(in_idx2)<0.5
        %                 continue;
        %             end
        %         else
        %             continue;
        %         end
    end
    
    boxes(1:5,t) = [box_cur', t+tmin-1]';
    %         attach_vec(t) = ntl+1;
end

%boxes = boxes(:, boxes(5,:)~=0);
bwl=bwlabel(boxes(5,:)~=0);
centers=unique(bwlabel(boxes(5,:)~=0));
bins=hist(bwlabel(boxes(5,:)~=0),centers);

bins=bins(find(centers>0));
centers=centers(find(centers>0));

[maxim,is]=max(bins);
if maxim>0
    boxes=boxes(:,find(bwl==centers(is)));
else
    boxes=[];
end
% save all.mat
% load all.mat
%now check the timestamps with very few tajectories

XYT=cat(2,tr(:).XYTPos);
T=XYT(3,:);
tcenters=min(T):max(T);
bins=hist(T,tcenters);
bins=bins(ismember(tcenters,boxes(5,:)));
tcenters=boxes(5,:);
discard=[];
ts_check=setdiff(tcenters(bins<min_tr_sz),t_given);
ts_sure=tcenters(bins>1.5*min_tr_sz);
if length(ts_sure)<2
    discard=ts_check;
else
    for t=ts_check
        %chose closest sure frame
        [~,is]=min(abs(t-ts_sure));
        t_sure=ts_sure(is);
        %prediction
        v1=get_vertices2(boxes(1:4,boxes(5,:)==t_sure));
        
        for cnt=1:3
            if t<t_sure
                t_sure2=t_sure+cnt;
                
            else
                t_sure2=t_sure-cnt;
                
            end
            if sum(ts_sure==t_sure2)==0
                break;
            end
            
            v2=get_vertices2(boxes(1:4,boxes(5,:)==t_sure2));
            
            
            vel=[(v1(1:4,1)-v2(1:4,1))/abs(t_sure2-t_sure) (v1(1:4,2)-v2(1:4,2))/abs(t_sure2-t_sure)];
            %find trajectories inboth boxes t_sure and t_sure2, estimate velocities
            %and extrapolate to the new frame and compute box
            %      idx_cur = tr_id((XYT(3,:)==t_sure)) &tr_id((XYT(3,:)==t_sure2));
            %     xy_cur = XYT(1:2, idx_cur);
            
            %
            %     c1=c(t_boxes==t_sure);
            %     c2=c(t_boxes==t_sure2);
            %
            %     u=(c1-c2)/abs(t_sure2-t_sure);
            
            
            v_predicted=v1(1:4,:)+[vel(:,1)*abs(t-t_sure) vel(:,2)*abs(t-t_sure)];
            
            v_cur=get_vertices2(boxes(1:4,boxes(5,:)==t));
            %         figure,
            %                 plot(v_predicted(:,1),v_predicted(:,2),'.r')
            %                 hold on;
            %                   plot(v_cur(:,1),v_cur(:,2),'.g')
            
            score(cnt)=IoUboxes([v_cur(1,:) v_cur(3,:)]',[v_predicted(1,:) v_predicted(3,:)]');
        end
        %score=score(1:cnt);
        if ~exist('score','var')
            discard=[discard t];
        elseif mean(score)<0.95
            discard=[discard t];
        end
        
        
        
    end
    
end


boxes=boxes(:,ismember(boxes(5,:),setdiff(boxes(5,:),discard)));

end
