function box_cur = propagate_box(xy_ref, box_ref, xy_cur)

% construct A, b
ntr = size(xy_ref, 2);

A = zeros(2*ntr, 3);
b = zeros(2*ntr,1);

for i = 1:ntr
    A([2*i-1, 2*i],1) = (xy_ref(:,i)-box_ref(1:2));
    A([2*i-1, 2*i],2) = [1 0];
    A([2*i-1, 2*i],3) = [0 1];
    b([2*i-1, 2*i]) = xy_cur(:,i);
end

val = A\b;

a = val(1);
xmin = val(2);
ymin = val(3);

w_ref = box_ref(3)-box_ref(1)+1;
h_ref = box_ref(4)-box_ref(2)+1;

xmax = xmin+w_ref*a-1;
ymax = ymin+h_ref*a-1;

box_cur = [xmin, ymin, xmax, ymax]';