function [TrDltClusters_chosen,cl_selected]=...
    nmsCoclusters(TrDltClusters,imnames,tr,verbose)



ncl=length(TrDltClusters);
cl_scores=cat(2,TrDltClusters(:).cl_score);
[~,Is]=sort(cl_scores,'descend');

%% NMS
cl_selected=zeros(ncl,1);
cnt=0;
if ~exist('tr_labels','var')
    tr_labels=zeros(length(tr),1);
end
for i=1:ncl
    cl_id=Is(i);
%     if length(TrDltClusters(cl_id).ts)<2
%         continue;
%     end
    if (cl_scores(cl_id)==0)%||(cl_scores(cl_id)<=1 && TrDltClusters(cl_id).ncut<0.4  && sum(TrDltClusters(cl_id).label)<15)
        continue;
    end
    
    
    %intersection with already chosen clusters
    tr_intersection=(TrDltClusters(cl_id).label*double((tr_labels>0)))/(sum(TrDltClusters(cl_id).label)+eps);
    if isempty(TrDltClusters(cl_id).boxes)%isfield(TrDltClusters,'boxes')
        box_intersection=0;
    else
        Boxes=cat(2,TrDltClusters(cl_selected==1).boxes);
        if isempty(Boxes)
            box_intersection=0;
        else
            box_intersection=...
                IoUboxes_mean(TrDltClusters(cl_id).boxes,Boxes);
        end
    end
    if (tr_intersection>=0.15)||box_intersection>=0.85 
        continue; 
    end
    if (tr_intersection>0.15)&&(box_intersection>0.7)
        continue;
    end
    
    cnt=cnt+1;
    
    
    cl_selected(cl_id)=1;
    
    inds=find((cl_selected==1));
    [tr_labels,Boxes]=TrClusters2Trlabels(tr,TrDltClusters(inds));
    
    %     if verbose
    %                 Boxes=cat(2,TrDltClusters(cl_selected>0).boxes);
    %                 tr_labels=TrDltClusters2Trlabels(tr,TrDltClusters(cl_selected==1));
%             inds=find((cl_selected==1));
%             [tr_labels,Boxes]=TrClusters2Trlabels(tr,TrDltClusters(inds));
%             plot_trajectory_labels_boxes(tr, tr_labels, Boxes, ...
%                 imnames(1:5), ...
%                 [],cnt, cnt);
%     
% plot_trajectory_labels_boxes...
%     (tr, TrDltClusters(cl_id).label, TrDltClusters(cl_id).boxes, ...
%        imnames(1:end), ...
%          [],0, 1);
    %         %         h = plot_trajectory_clusters_boxes(TrDltClusters(cl_selected==1), Boxes, ...
    %         %                     imnames(1:1:end), ...
    %         %                     [],1,1,4);
    %         %         h = plot_trajectory_labels_boxes(tr, ...
    %         %             TrDltClusters(cl_id).label, cat(2,Detectlets(dlts_ids).box), imnames, 10, ...
    %         %             [],1, 1);
    %         %  pause(2);
    %         fprintf('')
    %     end
end
TrDltClusters_chosen=TrDltClusters(cl_selected==1);
TrDltClusters_chosen=cut_time(TrDltClusters_chosen,tr);

%%


end

function Clusters=cut_time(Clusters,tr);
% thresh=10;
for i=1:length(Clusters)
    trc=tr(Clusters(i).label==1);
    if ~isempty(trc)
        xyt=cat(2,trc.XYTPos);
        ts=Clusters(i).boxes(5,:);
        Clusters(i).XYT=xyt(:,ismember(xyt(3,:),ts));
    else
        Clusters(i).XYT=[];
    end
    %centers(inds)
end
end



