% function [V,S] = ncutar(A,R,nv,reg) 
% Input:
%    A = attraction, nonnegative
%    R = repulsion, nonnegative
%    nv = number of eigenvectors, default = 6
%    reg = regularization factor, default = 0
% Output:
%    V = generalized eigenvectors of A - R + D_R and D_A + D_R
%    S = eigenvalues

% Stella X. Yu, 1 March 2004.

function [V,S] = cncutar(A,R,nv,reg,U,ar_ratio,verbose)

if nargin<2,
    R = [];
end

if nargin<3 | isempty(nv),
    nv = min(np,6);
end

if nargin<4 | isempty(reg),
    reg = 0;
end

if nargin<5;
    U = [];
end

if nargin<6 | isempty(ar_ratio),
    ar_ratio = 0.5;
end


i = size(A,1);
j = size(R,1);
np = max(i,j);
if np==0, % both A and R are empty 
    V = []; S = [];
    return;
end

% fill in empty matrix, make A and R symmetric
if j==0, % ncut on A only
    if not(isequal(A,A')),
        A = A + A';
    end
    dr = zeros(np,1);
    W = A;
    d = full(sum(A,2));   
    
elseif i==0, % ncut on R only
    if not(isequal(R,R')),
        R = R + R';
    end
    dr = full(sum(R,2));
    W = - R;
    d = dr;
    
else % ncut on both A and R
    if not(isequal(A,A')),
        A = A + A';
    end 
    if not(isequal(R,R')),
        R = R + R';
    end
    dr = full(sum(R,2));
    W = A - R;
   % W = (1-ar_ratio)*A - ar_ratio*R;
    d = dr + full(sum(A,2));
end
%Wout=A;
clear A R
if not(issparse(W)),
    W = sparse(W);
end

% degrees and regularization
if reg>0,    
    d = d + reg * 2;
    dr = dr + reg;
end
W = W + spdiags(dr,0,np,np);

clear dr

% eigencuts
dih = 1./(sqrt(d)+eps);


%W0 = W;

%change!!!!
W = spmtimesd(W,dih,dih);

%dmat = spmtimesd(sparse(eye(size(W,1))),d,[]);


if not(isequal(W,W')),
    W = 0.5 * (W + W'); % ensure symmetry
end

% added feb09
% remove ill-conditioned constraints
if ~isempty(U),
    U = sparse(U);
    %xchange!!!!
    U = spmtimesd(U,[],1./full(eps+max(abs(U),[],1)));
    j = find(sum(abs(U),1)>1.005);
    i = [length(j),size(U,2)];
    if i(1)<i(2),
        disp(sprintf('%s: %d / %d constraints OK',mfilename,i));
    end
    U = U(:,j);
end


%
options.issym = 1;
options.disp = verbose;
if isempty(U), 
    [V,S] = eigs(W,nv,'LA',options);
    % ! tempory change
 %   [V,S] = eigs(dmat-W,dmat, nv,'SA',options);
else
    %change!!
     A = spmtimesd(U,dih,[]);

%show values of contraints
% figure(10),
% plot([1:size(U,1)]',U(:,1),'.');
% title('before adding the neibghors')
% figure(11),
% plot([1:size(U,1)]',A(:,1),'.');
% title('after adding the neibghors')
% pause;

    B = inv(A'*A);
    [V,S] = eigs(@barqpqz2,np,nv,'LA',options,W,A,B);
end

%orig: [V,S] = eigs(W,nv,'LA',options);
[i,j] = sort(diag(S)); 
S = i(end:-1:1);
V = V(:,j(end:-1:1)); 
V = V .* repmat(dih,1,nv);