function [TrClusters,chosen]=make_cluster_unimodal(TrClusters,tr,imnames,verbose)

im=imread(imnames(1).name);
[~,q,~]=size(im);

% disp('multimodal in x..')
f = mk_gaussian(5);
ncl=length(TrClusters);
ON=ones(ncl,1);
for ii=1:length(TrClusters)

    indsall=find(TrClusters(ii).label);
    trc=tr(TrClusters(ii).label);
    [xyt,tr_id]=quick_tr(trc);
    xyt=round(xyt);
    
    maxintime=0;
    tmax=0;
    for t=TrClusters(ii).ts
        tinds=find(xyt(3,:)==t);
        if length(tinds)<10
            continue;
        end
        x=xyt(1,tinds);
        centers=1:q;
        bins=hist(x,centers);
        % p=ksdensity(x,centers,'width',5);
        %plot(bins)
        [maxim,is]=max(bins);
        if maxim>maxintime
            maxintime=maxim;
            tmax=t;
        end
    end
    if tmax==0
        ON(ii)=0;
        continue;
    end
    t=tmax;
    
    tinds=find(xyt(3,:)==t);
    tr_id_c=tr_id(tinds);
    x=xyt(1,tinds);
    centers=1:q;
    %p=ksdensity(x,centers,'width',5);
    p=my_ksdensity(x,centers,f);
    [maxim,is]=max(p);
    x_mode=centers(is);
    x_0=centers(p<0.0001);
    x_right=[x_mode:min(x_0(x_0>x_mode))];
    if isempty(x_right)
        x_right=x_mode:q;
    end
    x_left=[max(x_0(x_0<x_mode)):x_mode];
    if isempty(x_left)
        x_left=1:x_mode;
    end
    xon=[x_left x_right];
    
    % xon=[max(x_0(x_0<=x_mode)):min(x_0(x_0>=x_mode))];
    
    on_tr=tr_id_c(ismember(x,xon));
    off_tr=setdiff(tr_id_c,on_tr);
    
    %now track it
    
    for t=tmax:max(TrClusters(ii).ts)
        tinds=find(xyt(3,:)==t);
        if length(tinds)<10
            continue;
        end
        
        tr_id_c=tr_id(tinds);
        x=xyt(1,tinds);
        centers=1:q;
        % p=my_ksdensity(x,centers,'width',5);
        p=my_ksdensity(x,centers,f);
        %     bins=hist(x,centers);
        
        %plot(bins)\
        [maxim,is]=max(p);
        x_mode=centers(is);
        x_0=centers(p<0.0001);
        %     x_right=[x_mode:min(x_0(x_0>x_mode))];
        %     x_left=[max(x_0(x_0<x_mode)):x_mode];
        %         xspare=[max(x_0(x_0<x_mode)):min(x_0(x_0>x_mode))];
        x_right=[x_mode:min(x_0(x_0>x_mode))];
        if isempty(x_right)
            x_right=x_mode:q;
        end
        x_left=[max(x_0(x_0<x_mode)):x_mode];
        if isempty(x_left)
            x_left=1:x_mode;
        end
        xspare=[x_left x_right];
        if length(intersect(on_tr,tr_id_c(ismember(x,xspare))))...
                >length(intersect(off_tr,tr_id_c(ismember(x,xspare))));
            on_tr_c=tr_id_c(ismember(x,xspare));
            on_tr=[on_tr on_tr_c];
            off_tr_c=setdiff(tr_id_c,on_tr_c);
            off_tr=[off_tr off_tr_c];
            
        else
            off_tr_c=tr_id_c(ismember(x,xspare));
            off_tr=[off_tr off_tr_c];
            on_tr_c=setdiff(tr_id_c,off_tr_c);
            on_tr=[on_tr on_tr_c];
            
        end
        %                  TrLabels=zeros(nnz(TrClusters(ii).label),1);
        %             TrLabels(on_tr)=1;
        %              TrLabels(off_tr)=2;
        %
        %             plot_trajectory_labels(tr(TrClusters(ii).label), TrLabels, imnames(t), ...
        %             1,0,0,  4);
        %   pause;
    end
    %       TrLabels=zeros(nnz(TrClusters(ii).label),1);
    %             TrLabels(on_tr)=1;
    %              TrLabels(off_tr)=2;
    %
    %             plot_trajectory_labels(tr(TrClusters(ii).label), TrLabels,...
    %                 imnames(TrClusters(ii).ts), ...
    %             1,0,0,  4);
    
    for t=min(TrClusters(ii).ts):tmax
        tinds=find(xyt(3,:)==t);
        if length(tinds)<10
            continue;
        end
        
        tr_id_c=tr_id(tinds);
        x=xyt(1,tinds);
        centers=1:q;
        % p=ksdensity(x,centers);
        p=my_ksdensity(x,centers,f);
        %     bins=hist(x,centers);
        
        %plot(bins)\
        [maxim,is]=max(p);
        x_mode=centers(is);
        x_0=centers(p<0.0001);
        %     x_right=[x_mode:min(x_0(x_0>x_mode))];
        %     x_left=[max(x_0(x_0<x_mode)):x_mode];
        %         xspare=[max(x_0(x_0<x_mode)):min(x_0(x_0>x_mode))];
        x_right=[x_mode:min(x_0(x_0>x_mode))];
        if isempty(x_right)
            x_right=x_mode:q;
        end
        x_left=[max(x_0(x_0<x_mode)):x_mode];
        if isempty(x_left)
            x_left=1:x_mode;
        end
        xspare=[x_left x_right];
        
        
        if length(intersect(on_tr,tr_id_c(ismember(x,xspare))))>length(intersect(off_tr,tr_id_c(ismember(x,xspare))));
            on_tr_c=tr_id_c(ismember(x,xspare));
            on_tr=[on_tr on_tr_c];
            off_tr_c=setdiff(tr_id_c,on_tr_c);
            off_tr=[off_tr off_tr_c];
            
        else
            off_tr_c=tr_id_c(ismember(x,xspare));
            off_tr=[off_tr off_tr_c];
            on_tr_c=setdiff(tr_id_c,off_tr_c);
            on_tr=[on_tr on_tr_c];
            
        end
        
    end
    on_tr=unique(on_tr);
    off_tr=unique(off_tr);
    on_tr=setdiff(on_tr,off_tr);
    if verbose
        
        TrLabels=zeros(nnz(TrClusters(ii).label),1);
        TrLabels(on_tr)=1;
        TrLabels(off_tr)=2;
        
        plot_trajectory_labels(tr(TrClusters(ii).label), TrLabels,...
            imnames(TrClusters(ii).ts), ...
            1,0,0,  4);
        set(gcf,'name',['Cluster ' num2str(ii)]);
    end
    if isempty(on_tr)
        
        
        TrClusters(ii).label=boolean(zeros(1,length(tr)));
        TrClusters(ii).ts=[];
        ON(ii)=0;
    else
        
        
        label=zeros(1,length(tr));
        label(indsall(on_tr))=1;
        TrClusters(ii).label=boolean(label);
        % TrClusters(j).label=TrLabels==cl_ids(j);
        [xyt]=quick_tr(tr(TrClusters(ii).label));
        TrClusters(ii).ts=[min(xyt(3,:)):max(xyt(3,:))];
    end
end
chosen=find(ON);
TrClusters=TrClusters(find(ON));

%


    function   p=my_ksdensity(x,centers,f);
        bins=hist(x,centers);
        p=conv(bins,f,'same');
    end
end