function [Detections, detection_masks] = detect_all(imnames,para)
%OUTPUT:
%DETECTIONS:[xmin;ymin;xmax;ymax;det_score]

poselet_detector=configure_poselet();
for i = 1:length(imnames)
    t=imnames(i).t;
    progress(sprintf('\t compute detections'),t, length(imnames));
    detection_file = fullfile(para.detection_dir, [get_last_filepart(imnames(i).name), '.mat']);
     if ~exist(detection_file, 'file')||1
        [detections,detection_masks]=detect(poselet_detector,...
            imnames(i).name,para);
        detections=[detections(1:4,:);t*ones(1,size(detections,2));...
            detections(5:end,:)];
        save(detection_file,'detections','detection_masks');
    else
        load(detection_file,'detections','detection_masks');
        
    end
    Detections{i}=detections;
    DetectionMasks{i}=detection_masks;
end
Detections = cat(2, Detections{:});
detection_masks=cat(1,DetectionMasks{:});
Detections(7,:) = 1:size(Detections,2);
end
function [detections,detection_masks]=detect(poselet_detector,imfile,para)
detection_masks={};
poselet_file = fullfile(para.poselet_dir, [get_image_name(imfile), '.mat']);
if ~exist(poselet_file, 'file')
    img = imread(imfile);
    [bounds_predictions,poselet_hits,torso_predictions]=detect_objects_in_image(img,poselet_detector.model);
    save(poselet_file, 'bounds_predictions', 'poselet_hits', 'torso_predictions');
else
    load(poselet_file);
end

%
% if 0
%     params.poselet_patches=poselet_patches;
%     params.all_torso_hits=torso_predictions;
%     params.all_poselet_hits=poselet_hits;
%     params.masks=fg_masks;
%     im1.image_file{1} = imnames(t).name;
%     bounds_predictions.image_id(:)=1;
%     params.all_poselet_hits.image_id(:)=1;
%     params.all_torso_hits.image_id(:)=1;
%     browse_hits(bounds_predictions,im1,params);
% end


bounds_predictions.bounds(1:4,:)=bounds_predictions.bounds(1:4,:);

poselet_hits.bounds(1:4,:)=poselet_hits.bounds(1:4,:);





detections = [round(bounds_predictions.bounds);...
    bounds_predictions.score';];
detections(3,:)=detections(1,:)+detections(3,:);
detections(4,:)=detections(2,:)+detections(4,:);

pick=detections(1,:)>0&detections(2,:)>0&detections(3,:)>0&...
    detections(4,:)>0;
detections=detections(:,pick);
bounds_predictions=bounds_predictions.select(pick);

%prune low scoring ones
pick=detections(5,:)>para.det_score_thresh;
detections=detections(:,pick);
if isempty(detections)
    return;
end
bounds_predictions=bounds_predictions.select(pick);
%non maxima suppresion

%visualizeDetectionsPf(detections,imfile,1);
[top, pick] = nmsDetections(detections', 0.8);
detections=detections(:,pick);
%visualizeDetectionsPf(detections,imfile,1);
bounds_predictions=bounds_predictions.select(pick);
%



%get detection masks
masks=poselet_detector.fg_masks_centered;
detection_masks=cell(size(detections,2),1);
for i = 1:size(detections,2)
    src_idx = bounds_predictions.src_idx{i};
    poselet_cur = poselet_hits.select(src_idx);
    [~, is] = sort(poselet_cur.score, 'descend');
    src_idx = src_idx(is(1:min(10, length(is))));
    %get mask
    %poselets related to the detection
    plets = [round(poselet_hits.bounds(:,src_idx));...
        poselet_hits.score(src_idx)';...
        single(poselet_hits.poselet_id(src_idx)')];
    mask_choose = masks(plets(6,:));
    dbox = detections(1:4, i);
    xspan = dbox(1):dbox(3)-1;
    yspan = dbox(2):dbox(4)-1;
    valid_xspan = xspan>0 & xspan<=para.q;
    valid_yspan = yspan>0 & yspan<=para.p;
    xspan = xspan(valid_xspan);
    yspan = yspan(valid_yspan);
    vote = zeros([para.p para.q]);
    count = zeros([para.p para.q]);
    %voting of the related poselets
    for j = 1:size(plets,2)
        box = plets(1:4, j);
        mask = mask_choose{j};
        %adapt generic poselt mask to current poselet configuration
        mask = imresize(mask, box(4)/size(mask, 1));
        box(4) = min(box(4), size(mask,1));
        box(3) = min(box(3), size(mask,2));
        mask = mask(1:box(4), 1:box(3));
        
        pxspan = box(1):box(1)+box(3)-1;
        pyspan = box(2):box(2)+box(4)-1;
        valid_pxspan = pxspan>=xspan(1) & pxspan<=xspan(end);
        valid_pyspan = pyspan>=yspan(1) & pyspan<=yspan(end);
        if (sum(valid_pxspan)==0 || sum(valid_pyspan)==0)
            continue;
        end
        vote(pyspan(valid_pyspan), pxspan(valid_pxspan)) = vote(pyspan(valid_pyspan), pxspan(valid_pxspan))+...
            mask(valid_pyspan, valid_pxspan);
        count(pyspan(valid_pyspan), pxspan(valid_pxspan)) = count(pyspan(valid_pyspan), pxspan(valid_pxspan))+1;
    end
    vote = vote./(count+eps);
    dmask = zeros(length(yspan), length(xspan));
    dmask(valid_yspan, valid_xspan) = vote(yspan, xspan);
    detection_masks{i} = dmask;
    
end

end