function [Detectlets,Detections2Detectlets]=compute_detectlets...
    (detections,...
    Detections2Tr,imnames,tr,para)
%Detectlet.box:
%xmin,ymin,xmax,ymax,t,det_id,score

para.thresh_linking_absolute=0.09;
Detections2Detectlets=detection_linking(detections,Detections2Tr,imnames,tr,para);
trlet_ids = setdiff(unique(Detections2Detectlets),0);
ntrlet = length(trlet_ids);
cnt = 0;
trlet_ids_long=[];
% save tracklets longer than para.trlet_len_thresh
% Detectlets: [xmin, ymin, xmax, ymax, fr, tl_id, det_id, det_score]
for i = 1:ntrlet
    det_ids = find(Detections2Detectlets==trlet_ids(i));
    cnt = cnt+1;
    tl = detections(1:5,det_ids);
    Detectlets(cnt).box = [tl;  det_ids'; detections(6,det_ids)];
    Detectlets(cnt).len = length(det_ids);
    Detectlets(cnt).confidence=sum(Detectlets(cnt).box(6,:));
    t=zeros(1,length(imnames));
    t(tl(5,:))=1;
    Detectlets(cnt).t=t;
end
ids=[1:length(Detectlets)];
[~,loc]=ismember(Detections2Detectlets,trlet_ids_long);
Detections2Detectlets(find(loc))=ids(loc(find(loc)));
Detections2Detectlets(find(loc==0))=0;
save(para.detectlet_file,'Detections2Detectlets','Detectlets');




function Detections2Detectlets=detection_linking(detections,Detections2Tr,...
    imnames,tr,para)
ndet=size(detections,2);
P=zeros(ndet);
Ts=detections(5,:);
ws=detections(3,:)-detections(1,:)+1;
hs=detections(4,:)-detections(2,:)+1;

[XYT,tr_id,tr]=quick_tr(tr,0);
XYT=round(XYT);


Detections2Tr=Detections2Tr>0.1;

%3. anchoring
% X,Y \in ntr \tims nf
X=zeros(length(tr),min(length(imnames),max(Ts)));
Y=zeros(length(tr),min(length(imnames),max(Ts)));
for t=1:min(length(imnames),max(Ts))
    tinds=find(XYT(3,:)==t);
    X(tr_id(tinds),t)=XYT(1,tinds);
    Y(tr_id(tinds),t)=XYT(2,tinds);
end



anchorx=zeros(ndet,length(tr));
anchory=zeros(ndet,length(tr));


for ii=1:ndet
    %fprintf('%d',ii);
    t=detections(5,ii);
    trids=find(Detections2Tr(ii,:));
    xs=X(trids,t);
    ys=Y(trids,t);
    b=find(xs>0);
    use=trids(b);
    xs=xs(b);
    ys=ys(b);
    bbox_corner=detections([1:2],ii);
    anchorx(ii,use) = (xs-bbox_corner(1));
    anchory(ii,use) = (ys-bbox_corner(2));
end


F=double(sparse(Detections2Tr));
intersections=F*F';
S=sum(F,2);
Si=S*ones(1,ndet);
unions=Si+Si'-intersections;
TrSharing=intersections./unions;
TrSharing(isnan(TrSharing))=0;
TrSharing=full(TrSharing);

clear p1 q1 p2 q2
for t=1:min(length(imnames),max(Ts))-1
    
    progress(sprintf('\t compute detection linking'),t, length(imnames)-1);
    
    %detection indices on consecutive frames
    inds1=find(Ts==t);
    inds2=find(Ts==t+1);
    if isempty(inds1) || isempty(inds2)
        continue;
    end
    %     visualizeDetectionsPf(detections(1:4,inds1),imnames(t).name,1);
    %     visualizeDetectionsPf(detections(1:4,inds2),imnames(t+1).name,2);
    

    w1=ws(inds1)'*ones(1,length(inds2));
    w2=ones(length(inds1),1)*ws(inds2);
    size_agreement=exp((-1)*((w1-w2)./min(cat(3,w1,w2),[],3)).^2/0.5);
 
    
    %. anchoring
    AnchorXMatch=zeros(length(inds1),length(inds2));
    AnchorYMatch=zeros(length(inds1),length(inds2));
    for ii=1:length(inds1);
        for jj=1:length(inds2);
            if TrSharing(inds1(ii),inds2(jj))<para.tr_sharing_thresh
                continue;
            end
            trinds=find(Detections2Tr(inds1(ii),:).*Detections2Tr(inds2(jj),:));
            ScS=abs(median(anchorx(inds1(ii),trinds)-anchorx(inds2(jj),trinds)));
            AnchorXMatch(ii,jj)=exp(-ScS/20);
            ScS2=abs(median(anchory(inds1(ii),trinds)-anchory(inds2(jj),trinds)));
            AnchorYMatch(ii,jj)=exp(-ScS2/20);
            
            
        end
    end
    
    
    %fusion
    A=(TrSharing(inds1,inds2)>para.tr_sharing_thresh)...
        .*size_agreement.*AnchorXMatch.*AnchorYMatch;
    Athresh=double_threshold(A,para.thresh_linking_absolute,para.thresh_linking_relative);
    
    
    P(inds1,inds2)=Athresh;
    
end


[Paths,Path_Lengths]=trace_P(P);



Detections2Detectlets=zeros(ndet,1);
%path_inds=find(Path_Lengths>1);
path_inds=[1:length(Paths)];
for ii=1:length(path_inds)
    Detections2Detectlets(Paths{path_inds(ii)})=ii;
end
