function Rtr=computeTrRepulsions(Rdtl,Detectlets2Tr,tr,Detectlets,imnames,para)





ndtl=length(Detectlets);



if ndtl==0
    Rtr=[];
    return;
end
ntr=length(tr);
Detectlets2Trbin=Detectlets2Tr>0;
[XYT,tr_id]=quick_tr(tr);

%frame ids detectlets are on
Ts=cell(length(Detectlets));
for ii=1:length(Detectlets)
    Ts{ii}=Detectlets(ii).box(5,:);
end

%trajectory ids in frames
tr_ids=cell(length(imnames));
for t=1:length(imnames)
    tr_ids{t}=tr_id(XYT(3,:)==t);
end

%% voting for repulsion
%get pairs of competing tracklets
[i,j]=find(tril(Rdtl)>0);
Rtr=cell(length(i),1);
for k=1:length(i)
    
    progress(sprintf('\t trajectory repulsions from detectlet repulsions'),k, length(i));
    
    %common frames of the two incompatible detectlets
    tcomon=intersect(Ts{i(k)},Ts{j(k)});
    if isempty(tcomon)
        error('problem with detectlet repulsions');
    end
    %get trajectory ids of xor belonging to the 2 detectlets and
    %on on the common period
    tr_ids_incomp=intersect(find(xor(Detectlets2Trbin(i(k),:),...
        Detectlets2Tr(j(k),:))),...
        cat(2,tr_ids{tcomon}));
    
    tr_ids_incomp_i=tr_ids_incomp(Detectlets2Trbin(i(k),tr_ids_incomp)==1);
    tr_ids_incomp_j=tr_ids_incomp(Detectlets2Trbin(j(k),tr_ids_incomp)==1);
    [tr_ids_incomp_i,tr_ids_incomp_j]=ndgrid(tr_ids_incomp_i,tr_ids_incomp_j);
    tr_ids_incomp_i=tr_ids_incomp_i(:);
    tr_ids_incomp_j=tr_ids_incomp_j(:);
    
    vote_weights=Detectlets(i(k)).confidence*...
        Detectlets(j(k)).confidence*Detectlets2Tr(i(k),tr_ids_incomp_i)...
        .*Detectlets2Tr(j(k),tr_ids_incomp_j);
    Rtr{k}=sparse(tr_ids_incomp_i,tr_ids_incomp_j,double(vote_weights'),ntr,ntr);
    Rtr{k}=max(Rtr{k},Rtr{k}');
    %     votes(tr_ids_incomp_i,tr_ids_incomp_j)=...
    %         votes(tr_ids_incomp_i,tr_ids_incomp_j)+1;
    %     votes(tr_ids_incomp_j,tr_ids_incomp_i)=...
    %         votes(tr_ids_incomp_j,tr_ids_incomp_i)+1;
end
Rtr_f=sparse(ntr,ntr);
for i=1:length(Rtr)
    Rtr_f=Rtr_f+Rtr{i};
end
%% voting for non-repulsion
%get pairs of competing tracklets
%[i,j]=find(tril(Rdtl)>0);
Rtr=cell(ndtl,1);
for i=1:ndtl
    %common frames of the two incompatible detectlets
    
    
    %get trajectory ids of xor belonging to the 2 detectlets and
    %on on the common period
    tr_ids_in=find(Detectlets2Trbin(i,:));
    
    [tr_ids_in_i,tr_ids_in_j]=...
        ndgrid(tr_ids_in,tr_ids_in);
    tr_ids_in_i=tr_ids_in_i(:);
    tr_ids_in_j=tr_ids_in_j(:);
    
    %voting
    vote_weights=Detectlets(i).confidence^2*...
        Detectlets2Tr(i,tr_ids_in_i)...
        .*Detectlets2Tr(i,tr_ids_in_j);
    
    Rtr{i}=(-1)*sparse(tr_ids_in_i,tr_ids_in_j,double(vote_weights'),ntr,ntr);
    Rtr{i}=min(Rtr{i},Rtr{i}');
    
    %     votes(tr_ids_in_i,tr_ids_in_j)=...
    %         votes(tr_ids_in_i,tr_ids_in_j)+1;
    %     votes(tr_ids_in_j,tr_ids_in_i)=...
    %         votes(tr_ids_in_j,tr_ids_in_i)+1;
    
    
end
%Rtr_f=sparse(ntr,ntr);
for i=1:length(Rtr)
    Rtr_f=Rtr_f+Rtr{i};
end
Rtr=Rtr_f;

% Rtr=Rtr./votes;
Rtr=max(Rtr,0);
Rtr=min(Rtr,1);

%zero out the diagonal
Rtr = Rtr.*(~eye(size(Rtr)));