function [A,Amotion,Adisp]=computeTrAffinities(tr,para,verbose)

Adisp=[];
if ~exist('verbose','var') | isempty(verbose)
    verbose = 1;
end

tic;
%away from 2*cuttoff alays affinity zero

cutoffx=para.dist_thresh_x;
cutoffy=para.dist_thresh_y;
aggr=para.aggr;
lens=get_tr_lengths(tr);
aggr=min(aggr,min(lens));
my_var_euk=para.my_var_euk;
my_var_ut=para.my_var_ut;
sample_step = para.sample_step;

ntr=length(tr);

switch verbose
    case {1,2},
        fprintf('\t\t\t computing motion attractive affinites - velocities \n');
end
%******************compute velocities Us*****************************%
%******************BUGS HERE, fix later *****************************%
for ii=1:length(tr)
    XYTc=tr(ii).XYTPos;
    v=XYTc(1:2,aggr:end)-XYTc(1:2,1:end-aggr+1); %% velocities different
    if isempty(v)
        error('error!');
    end
    Us{ii}=v;
    tr(ii).XYTPos=XYTc(:,1:end-aggr+1); %% keep the time
    if para.stereo
        tr(ii).disparity=tr(ii).disparity(1:end-aggr+1);
    end
end

[XYT,tr_id,tr]=quick_tr(tr,0);

%% Concatenate all the velocities.
Us=cat(2,Us{:});
trFrame=get_help_struct(tr);



[~,Is1]=unique(tr_id,'first');
[~,Is2]=unique(tr_id,'last');

switch verbose
    case {1,2},
        fprintf('\t\t\t computing motion attractive affinites - neighbour \n');
end

[pi, pj] = compute_Atraj_neighbour(tr, trFrame, cutoffx, cutoffy, sample_step,verbose);


switch verbose
    case {1,2},
        fprintf('\t\t\t computing motion attractive affinites - weights \n');
end
Amotion = compute_Atraj_maxu_maxdist(XYT(1,:)', XYT(2,:)', XYT(3,:)', Us(1,:)', Us(2,:)', size(XYT,2),...
    Is1'-1, Is2'-1, ntr,...
    my_var_euk, pi, pj,verbose, my_var_ut);
if para.stereo==0
 clear pi; clear pj;
end
Amotion=max(Amotion,Amotion');
A=Amotion;
% save all.mat
% %%
% load all.mat
if para.stereo
    para_stereo=get_para_stereo();
    TrDisparities=cat(2,tr(:).disparity)';
    
    TrDisparities(TrDisparities>para_stereo.maxd | ...
        TrDisparities<para_stereo.mind)=para.lower_bound_disparity;
    switch verbose
        case {1,2},
            fprintf('\t\t\t computing disparity attractive affinites - weights \n');
    end
    
    Adisp = compute_Atraj_maxdisp_maxdist(XYT(1,:)', XYT(2,:)', XYT(3,:)', ...
        TrDisparities, size(XYT,2),Is1'-1, Is2'-1, ntr,...
        my_var_euk, pi, pj,verbose, para.my_var_disp,para.lower_bound_disparity);
    clear pi; clear pj;
    Adisp=max(Adisp,Adisp');
    A=A.*Adisp;
    A(Adisp==-1)=Amotion(Adisp==-1);
end



