function CoclustersSteer=TrDltSteeringCut(tr,  Detectlets,...
     Detectlets2Tr,imnames,nv,para)


%% Trajectory Affinities
fprintf('\t\t compute trajectory affinities: (%d traj)\n', length(tr));
[Atr]         =  computeTrAffinities(tr,para,0);

%% Detectlet repulsions

Rdtl = computeDltRepulsions(Detectlets);

%% Tr repulsions %%
dlt_ids_select=find(cat(1,Detectlets(:).len)>=para.min_dlt_len_steer);
Rtr=computeTrRepulsions(Rdtl(dlt_ids_select,dlt_ids_select),...
    Detectlets2Tr(dlt_ids_select,:),tr,Detectlets(dlt_ids_select),imnames,para);

%% Steered Tr Affinities
Atr_steer = Atr.*(Rtr==0);




%%   Ncut %%
fprintf('ncut  \n');
[Vtr,Str] = cncutar(sparse(Atr_steer),[],nv,0,[],0,0);
nv=length(find(Str>para.spectral_gap_th));



%% multiple discretizations %%
Ks = 3:max(1,floor(nv/30)):nv;
TrClusters=cell(length(Ks),1);
cnt=0;
for k=Ks
    progress(sprintf('\t discretization'),cnt, length(Ks)-1);
    binsol = getbinsol(Vtr(:,1:k));
    TrLabels = full(sum(binsol.*repmat(1:k, size(binsol,1),1),2)');
    cnt=cnt+1;
    TrClusters{cnt}=TrLabels2TrClusters(tr,TrLabels);
end

TrClusters=cat(2,TrClusters{:});
TrClusters=remove_duplicate_clusters(TrClusters);
% save all.mat
% load all.mat
%% post process clusters

[TrClusters]=make_cluster_unimodal(TrClusters,tr,...
    imnames, 0);
TrClusters=time_unimodal(TrClusters,tr);
TrClusters=remove_duplicate_clusters(TrClusters);
TrClusters=compute_ncut_cluster_scores(Atr_steer,TrClusters);
TrClusters=TrClusters(cat(2,TrClusters(:).ncut)>para.ncut_score_thresh);

save('all.mat');
load('all.mat');

%% Align TrClusters 2 Dlts
CoclustersSteer=alignTrclustersToDetectlets(Detectlets,tr,Rtr,...
    Detectlets2Tr,TrClusters,imnames,para);



end